/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.tr.yapi.ek;

import java.util.logging.Logger;
import net.zemberek.araclar.Kayitci;
import net.zemberek.tr.yapi.ek.BeraberlikIsOzelDurumu;
import net.zemberek.tr.yapi.ek.EdilgenOzelDurumu;
import net.zemberek.tr.yapi.ek.GenisZamanEkOzelDurumuTr;
import net.zemberek.tr.yapi.ek.SimdikiZamanEkOzelDurumuTr;
import net.zemberek.tr.yapi.ek.SuOzelDurumu;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.ek.EkOzelDurumTipi;
import net.zemberek.yapi.ek.EkOzelDurumu;
import net.zemberek.yapi.ek.TemelEkOzelDurumUretici;

public class TurkceEkOzelDurumUretici
extends TemelEkOzelDurumUretici {
    private static Logger logger = Kayitci.kayitciUret(TurkceEkOzelDurumUretici.class);

    public TurkceEkOzelDurumUretici(Alfabe alfabe) {
        this.alfabe = alfabe;
    }

    public EkOzelDurumu uret(String ad) {
        EkOzelDurumu oz = super.uret(ad);
        if (oz != null) {
            return oz;
        }
        if (!this.mevcut(TurkceEkOzelDurumTipi.values(), ad)) {
            logger.severe("Ozel durum adina karsilik dusen ek ozel durum tipi bulunamadi:" + ad);
            return null;
        }
        switch (TurkceEkOzelDurumTipi.valueOf(ad)) {
            case BERABERLIK_IS: {
                return new BeraberlikIsOzelDurumu();
            }
            case EDILGEN: {
                return new EdilgenOzelDurumu(this.alfabe);
            }
            case GENIS_ZAMAN: {
                return new GenisZamanEkOzelDurumuTr();
            }
            case SIMDIKI_ZAMAN: {
                return new SimdikiZamanEkOzelDurumuTr(this.alfabe);
            }
            case SU: {
                return new SuOzelDurumu();
            }
        }
        return oz;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TurkceEkOzelDurumTipi implements EkOzelDurumTipi
    {
        BERABERLIK_IS,
        EDILGEN,
        GENIS_ZAMAN,
        SIMDIKI_ZAMAN,
        SU;


        public String ad() {
            return this.name();
        }
    }
}

