/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.tr.yapi.ek;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.zemberek.tr.yapi.TurkceSesliUretici;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.TurkceHarf;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.ek.EkUretici;
import net.zemberek.yapi.ek.EkUretimBileseni;
import net.zemberek.yapi.ek.TemelEkUretici;
import net.zemberek.yapi.ek.TemelEkUretimKurali;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EkUreticiTr
extends TemelEkUretici
implements EkUretici {
    private TurkceSesliUretici sesliUretici;
    public final TurkceHarf HARF_a;
    public final TurkceHarf HARF_e;
    public final TurkceHarf HARF_i;
    public final TurkceHarf HARF_ii;
    public final TurkceHarf HARF_u;
    public final TurkceHarf HARF_uu;

    public EkUreticiTr(Alfabe alfabe) {
        this.sesliUretici = new TurkceSesliUretici(alfabe);
        this.HARF_a = alfabe.harf('a');
        this.HARF_e = alfabe.harf('e');
        this.HARF_i = alfabe.harf('i');
        this.HARF_ii = alfabe.harf('\u0131');
        this.HARF_u = alfabe.harf('u');
        this.HARF_uu = alfabe.harf('\u00fc');
    }

    public HarfDizisi cozumlemeIcinEkUret(HarfDizisi ulanacak, HarfDizisi giris, List<EkUretimBileseni> bilesenler) {
        HarfDizisi sonuc = new HarfDizisi(4);
        TurkceHarf sonSesli = ulanacak.sonSesli();
        block8: for (int i = 0; i < bilesenler.size(); ++i) {
            EkUretimBileseni ekUretimBileseni = bilesenler.get(i);
            TurkceHarf harf = ekUretimBileseni.harf;
            switch ((TemelEkUretimKurali)ekUretimBileseni.kural) {
                case HARF: {
                    sonuc.ekle(harf);
                    continue block8;
                }
                case KAYNASTIR: {
                    if (!ulanacak.sonHarf().sesliMi()) continue block8;
                    sonuc.ekle(harf);
                    continue block8;
                }
                case SERTLESTIR: {
                    if (ulanacak.sonHarf().sertMi()) {
                        sonuc.ekle(harf.sertDonusum());
                        continue block8;
                    }
                    sonuc.ekle(harf);
                    continue block8;
                }
                case YUMUSAT: {
                    if (giris.harf(ulanacak.length() + sonuc.length() + 1).sesliMi()) {
                        sonuc.ekle(harf.yumusama());
                        continue block8;
                    }
                    sonuc.ekle(harf);
                    continue block8;
                }
                case SESLI_AE: {
                    if (i == 0 && ulanacak.sonHarf().sesliMi()) continue block8;
                    sonSesli = this.sesliUretici.sesliBelirleAE(sonSesli);
                    sonuc.ekle(sonSesli);
                    continue block8;
                }
                case SESLI_IU: {
                    if (i == 0 && ulanacak.sonHarf().sesliMi()) continue block8;
                    sonSesli = this.sesliUretici.sesliBelirleIU(sonSesli);
                    sonuc.ekle(sonSesli);
                }
            }
        }
        return sonuc;
    }

    public HarfDizisi olusumIcinEkUret(HarfDizisi ulanacak, Ek sonrakiEk, List<EkUretimBileseni> bilesenler) {
        if (bilesenler.size() == 0) {
            return HarfDizisi.BOS_DIZI;
        }
        HarfDizisi sonuc = this.cozumlemeIcinEkUret(ulanacak, ulanacak, bilesenler);
        if (sonrakiEk.sesliIleBaslayabilirMi() && bilesenler.get((int)(bilesenler.size() - 1)).kural == TemelEkUretimKurali.YUMUSAT) {
            sonuc.sonHarfYumusat();
        }
        return sonuc;
    }

    public Set<TurkceHarf> olasiBaslangicHarfleri(List<EkUretimBileseni> bilesenler) {
        HashSet<TurkceHarf> kume = new HashSet<TurkceHarf>(4);
        block7: for (int i = 0; i < bilesenler.size(); ++i) {
            EkUretimBileseni bilesen = bilesenler.get(i);
            TurkceHarf harf = bilesen.harf;
            switch ((TemelEkUretimKurali)bilesen.kural) {
                case HARF: {
                    kume.add(harf);
                    return kume;
                }
                case KAYNASTIR: {
                    kume.add(harf);
                    continue block7;
                }
                case SERTLESTIR: {
                    kume.add(harf);
                    kume.add(harf.sertDonusum());
                    return kume;
                }
                case SESLI_AE: {
                    kume.add(this.HARF_a);
                    kume.add(this.HARF_e);
                    if (i > 0) {
                        return kume;
                    }
                }
                case SESLI_IU: {
                    kume.add(this.HARF_i);
                    kume.add(this.HARF_u);
                    kume.add(this.HARF_ii);
                    kume.add(this.HARF_uu);
                    if (i <= 0) continue block7;
                    return kume;
                }
            }
        }
        return kume;
    }
}

