/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.tr.islemler;

import java.util.List;
import java.util.Locale;
import net.zemberek.islemler.cozumleme.CozumlemeYardimcisi;
import net.zemberek.tr.yapi.kok.TurkceKokOzelDurumTipleri;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.Kisaltma;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.TurkceHarf;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.kok.KokOzelDurumTipi;

public class TurkceCozumlemeYardimcisi
implements CozumlemeYardimcisi {
    private Alfabe alfabe;
    Locale TR = new Locale("tr");

    public TurkceCozumlemeYardimcisi(Alfabe alfabe) {
        this.alfabe = alfabe;
    }

    public void kelimeBicimlendir(Kelime kelime) {
        Kok kok = kelime.kok();
        HarfDizisi olusan = kelime.icerik();
        if (kok instanceof Kisaltma) {
            int silinecek = kok.icerik().length();
            if (kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.KISALTMA_SON_SESSIZ)) {
                silinecek += 2;
            }
            if (kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.KISALTMA_SON_SESLI)) {
                ++silinecek;
            }
            olusan.harfSil(0, silinecek);
            olusan.ekle(0, new HarfDizisi(kok.asil(), this.alfabe));
            if (olusan.length() == kok.asil().length()) {
                return;
            }
            if (!olusan.harf(kok.asil().length() - 1).equals(this.alfabe.harf('.'))) {
                olusan.ekle(kok.asil().length(), this.alfabe.harf('\''));
            }
        } else if (kok.tip() == KelimeTipi.OZEL) {
            Ek ek;
            olusan.harfDegistir(0, this.alfabe.buyukHarf(olusan.ilkHarf()));
            if (kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.KESMESIZ)) {
                return;
            }
            List ekler = kelime.ekler();
            if (ekler.size() > 1 && ((ek = (Ek)ekler.get(1)).iyelikEkiMi() || ek.halEkiMi())) {
                int kesmePozisyonu = kok.icerik().length();
                olusan.ekle(kesmePozisyonu, this.alfabe.harf('\''));
            }
        } else if (kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.OZEL_IC_KARAKTER)) {
            int silinecek = kok.icerik().length();
            olusan.harfSil(0, silinecek);
            olusan.ekle(0, new HarfDizisi(kok.asil(), this.alfabe));
        }
    }

    public boolean kelimeBicimiDenetle(Kelime kelime, String giris) {
        if (giris.length() == 0) {
            return false;
        }
        Kok kok = kelime.kok();
        if (kok.tip().equals((Object)KelimeTipi.KISALTMA)) {
            String as = kok.asil();
            if (!giris.startsWith(as)) {
                return false;
            }
            if (giris.equals(as)) {
                return true;
            }
            String kalan = giris.substring(as.length());
            if (as.charAt(as.length() - 1) == '.') {
                return kalan.charAt(0) != '\'';
            }
            return kalan.charAt(0) == '\'';
        }
        if (kelime.kok().tip() == KelimeTipi.OZEL) {
            Ek ek;
            if (Character.isLowerCase(giris.charAt(0))) {
                return false;
            }
            if (kelime.kok().ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.KESMESIZ)) {
                return true;
            }
            List ekler = kelime.ekler();
            if (ekler.size() > 1 && ((ek = (Ek)ekler.get(1)).iyelikEkiMi() || ek.halEkiMi())) {
                int kesmePozisyonu = kelime.kok().icerik().length();
                return kesmePozisyonu <= giris.length() && giris.charAt(kesmePozisyonu) == '\'';
            }
        }
        return true;
    }

    public boolean kokGirisDegismiVarsaUygula(Kok kok, HarfDizisi kokDizi, HarfDizisi girisDizi) {
        if (girisDizi != null && girisDizi.length() == 0) {
            return false;
        }
        if (kok instanceof Kisaltma) {
            char c = ((Kisaltma)kok).getKisaltmaSonSeslisi();
            if (c == '\u0000') {
                return false;
            }
            TurkceHarf h = this.alfabe.harf(c);
            kokDizi.ekle(h);
            int kokBoyu = kok.icerik().length();
            if (girisDizi != null) {
                if (kokBoyu <= girisDizi.length()) {
                    girisDizi.ekle(kokBoyu, h);
                } else {
                    girisDizi.ekle(h);
                }
            }
            if (kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.KISALTMA_SON_SESSIZ)) {
                kokDizi.ekle(this.alfabe.harf('b'));
                if (girisDizi != null) {
                    if (kokBoyu < girisDizi.length()) {
                        girisDizi.ekle(kokBoyu + 1, this.alfabe.harf('b'));
                    } else {
                        girisDizi.ekle(this.alfabe.harf('b'));
                    }
                }
            }
            return true;
        }
        return false;
    }
}

