/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi.kok;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import net.zemberek.araclar.Kayitci;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.ek.EkYonetici;
import net.zemberek.yapi.kok.BosHarfDizisiIslemi;
import net.zemberek.yapi.kok.HarfDizisiIslemi;
import net.zemberek.yapi.kok.KokOzelDurumTipi;
import net.zemberek.yapi.kok.KokOzelDurumu;

public class TemelKokOzelDurumBilgisi {
    protected static Logger logger = Kayitci.kayitciUret(TemelKokOzelDurumBilgisi.class);
    protected EkYonetici ekYonetici;
    protected Alfabe alfabe;
    protected Map<KokOzelDurumTipi, KokOzelDurumu> ozelDurumlar = new HashMap<KokOzelDurumTipi, KokOzelDurumu>();
    protected Map<String, KokOzelDurumu> kisaAdOzelDurumlar = new HashMap<String, KokOzelDurumu>();
    public static final int MAX_OZEL_DURUM_SAYISI = 30;
    protected KokOzelDurumu[] ozelDurumDizisi = new KokOzelDurumu[30];

    public TemelKokOzelDurumBilgisi(EkYonetici ekYonetici, Alfabe alfabe) {
        this.ekYonetici = ekYonetici;
        this.alfabe = alfabe;
    }

    public KokOzelDurumu ozelDurum(int indeks) {
        if (indeks < 0 || indeks >= this.ozelDurumDizisi.length) {
            throw new IndexOutOfBoundsException("istenilen indeksli ozel durum mevcut degil:" + indeks);
        }
        return this.ozelDurumDizisi[indeks];
    }

    public KokOzelDurumu kisaAdIleOzelDurum(String ozelDurumKisaAdi) {
        return this.kisaAdOzelDurumlar.get(ozelDurumKisaAdi);
    }

    protected KokOzelDurumu.Uretici uretici(KokOzelDurumTipi tip, HarfDizisiIslemi islem) {
        KokOzelDurumu.Uretici uretici = new KokOzelDurumu.Uretici(tip, islem);
        String[] ekAdlari = tip.ekAdlari();
        if (ekAdlari.length > 0) {
            HashSet<Ek> set = new HashSet<Ek>(ekAdlari.length);
            for (String s : ekAdlari) {
                Ek ek = this.ekYonetici.ek(s);
                if (ek != null) {
                    set.add(ek);
                    continue;
                }
                logger.warning(s + " eki bulunamadigindan kok ozel durumuna eklenemedi!");
            }
            uretici.gelebilecekEkler(set);
        }
        return uretici;
    }

    protected void ekle(KokOzelDurumu.Uretici uretici) {
        KokOzelDurumu ozelDurum = uretici.uret();
        this.ozelDurumlar.put(ozelDurum.tip(), ozelDurum);
        this.ozelDurumDizisi[ozelDurum.indeks()] = ozelDurum;
        this.kisaAdOzelDurumlar.put(ozelDurum.kisaAd(), ozelDurum);
    }

    protected void bosOzelDurumEkle(KokOzelDurumTipi ... tipler) {
        for (KokOzelDurumTipi tip : tipler) {
            this.ekle(this.uretici(tip, new BosHarfDizisiIslemi()));
        }
    }

    public KokOzelDurumu ozelDurum(String kisaAd) {
        return this.kisaAdOzelDurumlar.get(kisaAd);
    }

    public KokOzelDurumu ozelDurum(KokOzelDurumTipi tip) {
        return this.ozelDurumlar.get(tip);
    }
}

