/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi.kok;

import java.util.HashSet;
import java.util.Set;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.kok.HarfDizisiIslemi;
import net.zemberek.yapi.kok.KokOzelDurumTipi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KokOzelDurumu {
    private KokOzelDurumTipi tip;
    private HarfDizisiIslemi islem;
    private Set<Ek> gelebilecekEkler = new HashSet<Ek>();
    private boolean yapiBozucu = false;
    private boolean secimlik = false;
    private boolean ekKisitlayici = false;
    private boolean sesliEkIleOlusur = false;
    private boolean herZamanOlusur = false;
    private boolean otomatikBelirlenir = false;

    private KokOzelDurumu(Uretici uretici) {
        this.gelebilecekEkler = uretici.gelebilecekEkler;
        this.sesliEkIleOlusur = uretici.sesliEkIleOlusur;
        this.yapiBozucu = uretici.yapiBozucu;
        this.secimlik = uretici.secimlik;
        this.ekKisitlayici = uretici.ekKisitlayici;
        this.tip = uretici.tip;
        this.islem = uretici.islem;
        this.herZamanOlusur = uretici.herZamanOlusur;
        this.otomatikBelirlenir = uretici.otomatikBelirlenir;
    }

    public boolean yapiBozucumu() {
        return this.yapiBozucu;
    }

    public boolean secimlikmi() {
        return this.secimlik;
    }

    public boolean seslikEkleolusurmu() {
        return this.sesliEkIleOlusur;
    }

    public Set<Ek> geleibilecekEkler() {
        return this.gelebilecekEkler;
    }

    public boolean otomatikbelilenir() {
        return this.otomatikBelirlenir;
    }

    public boolean ekKisitlayiciMi() {
        return this.ekKisitlayici;
    }

    public int indeks() {
        return this.tip.indeks();
    }

    public String kisaAd() {
        return this.tip.kisaAd();
    }

    public KokOzelDurumTipi tip() {
        return this.tip;
    }

    public void uygula(HarfDizisi dizi) {
        this.islem.uygula(dizi);
    }

    public boolean olusabilirMi(Ek ek) {
        if (this.herZamanOlusur) {
            return true;
        }
        if (this.sesliEkIleOlusur && ek.sesliIleBaslayabilirMi()) {
            return true;
        }
        return this.gelebilecekEkler.contains(ek);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KokOzelDurumu that = (KokOzelDurumu)o;
        return this.tip.indeks() == that.tip.indeks() && this.tip.ad().equals(that.tip.ad());
    }

    public int hashCode() {
        return this.tip.ad().hashCode() * this.tip.indeks();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Uretici {
        private Set<Ek> gelebilecekEkler = new HashSet<Ek>();
        private boolean sesliEkIleOlusur = false;
        private boolean yapiBozucu = false;
        private boolean secimlik = false;
        private boolean ekKisitlayici = false;
        private HarfDizisiIslemi islem;
        private KokOzelDurumTipi tip;
        private boolean herZamanOlusur = false;
        private boolean otomatikBelirlenir = false;

        public Uretici(KokOzelDurumTipi tip, HarfDizisiIslemi islem) {
            this.tip = tip;
            this.islem = islem;
        }

        public Uretici gelebilecekEkler(Set<Ek> ekler) {
            this.gelebilecekEkler = ekler;
            return this;
        }

        public Uretici sesliEkIleOlusur(boolean deger) {
            this.sesliEkIleOlusur = deger;
            return this;
        }

        public Uretici yapiBozucu(boolean yapiBozucu) {
            this.yapiBozucu = yapiBozucu;
            return this;
        }

        public Uretici secimlik(boolean secimlik) {
            this.secimlik = secimlik;
            return this;
        }

        public Uretici ekKisitlayici(boolean ekKisitlayici) {
            this.ekKisitlayici = ekKisitlayici;
            return this;
        }

        public Uretici herZamanOlusur(boolean herZamanOlusur) {
            this.herZamanOlusur = herZamanOlusur;
            return this;
        }

        public Uretici parametre(KokOzelDurumTipi tip) {
            this.tip = tip;
            return this;
        }

        public Uretici otomatikBelirlenir(boolean otomatikBelilenir) {
            this.otomatikBelirlenir = otomatikBelilenir;
            return this;
        }

        public KokOzelDurumu uret() {
            return new KokOzelDurumu(this);
        }
    }
}

