/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi.ek;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.zemberek.araclar.Kayitci;
import net.zemberek.araclar.XmlYardimcisi;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.ek.EkKonfigurasyonHatasi;
import net.zemberek.yapi.ek.EkKuralKelimesiCozumleyici;
import net.zemberek.yapi.ek.EkOzelDurumUretici;
import net.zemberek.yapi.ek.EkOzelDurumu;
import net.zemberek.yapi.ek.EkUretici;
import net.zemberek.yapi.ek.EkUretimBileseni;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEkOkuyucu {
    private static Logger log = Kayitci.kayitciUret(XmlEkOkuyucu.class);
    private Map<String, Set<Ek>> ekKumeleri = new HashMap<String, Set<Ek>>();
    private Map<String, Ek> ekler = new HashMap<String, Ek>();
    private final String xmlEkDosyasi;
    private final EkUretici ekUretici;
    private final EkOzelDurumUretici ekOzelDurumUretici;
    private final EkKuralKelimesiCozumleyici kuralKelimesiCozumleyici;

    public XmlEkOkuyucu(String xmlEkDosyasi, EkUretici ekUretici, EkOzelDurumUretici ekOzelDurumUretici, EkKuralKelimesiCozumleyici kuralKelimesiCozumleyici) {
        this.xmlEkDosyasi = xmlEkDosyasi;
        this.ekUretici = ekUretici;
        this.ekOzelDurumUretici = ekOzelDurumUretici;
        this.kuralKelimesiCozumleyici = kuralKelimesiCozumleyici;
    }

    public Map<String, Ek> getEkler() {
        return this.ekler;
    }

    public void xmlOku() throws IOException {
        Document document = XmlYardimcisi.xmlDosyaCozumle(this.xmlEkDosyasi);
        Element kokElement = document.getDocumentElement();
        this.ilkEkleriOlustur(XmlYardimcisi.ilkEleman(kokElement, "ekler"));
        this.ekKumeleriniOlustur(XmlYardimcisi.ilkEleman(kokElement, "ek-kumeleri"));
        this.ekleriOlustur(XmlYardimcisi.ilkEleman(kokElement, "ekler"));
    }

    private void ilkEkleriOlustur(Element eklerElement) {
        List<Element> tumEkler = XmlYardimcisi.elemanlar(eklerElement, "ek");
        for (Element ekElement : tumEkler) {
            String ekadi = ekElement.getAttribute("ad");
            if (this.ekler.containsKey(ekadi)) {
                throw new EkKonfigurasyonHatasi("Ek tekrari! " + ekadi);
            }
            this.ekler.put(ekadi, new Ek(ekadi));
        }
    }

    private void ekKumeleriniOlustur(Element ekKumeleriElement) {
        List<Element> xmlKumeler = XmlYardimcisi.elemanlar(ekKumeleriElement, "ek-kumesi");
        for (Element ekKumeEl : xmlKumeler) {
            String kumeAdi = ekKumeEl.getAttribute("ad");
            HashSet<Ek> kumeEkleri = new HashSet<Ek>();
            List<Element> xmlKumeEkleri = XmlYardimcisi.elemanlar(ekKumeEl, "ek");
            for (Element ekEl : xmlKumeEkleri) {
                String ekAdi = ekEl.getTextContent();
                Ek ek = this.ekler.get(ekAdi);
                if (ek == null) {
                    throw new EkKonfigurasyonHatasi("kume eki bulunamiyor!" + ekAdi);
                }
                kumeEkleri.add(ek);
            }
            this.ekKumeleri.put(kumeAdi, kumeEkleri);
        }
    }

    private void ekleriOlustur(Element eklerElement) {
        List<Element> tumEkler = XmlYardimcisi.elemanlar(eklerElement, "ek");
        for (Element ekElement : tumEkler) {
            String ekAdi = ekElement.getAttribute("ad");
            Ek ek = this.ekler.get(ekAdi);
            Attr uretimKurali = ekElement.getAttributeNode("uretim");
            if (uretimKurali == null) {
                throw new EkKonfigurasyonHatasi("ek uretim kural kelimesi yok!" + ekAdi);
            }
            ek.setArdisilEkler(this.ardisilEkleriOlustur(ek, ekElement));
            ek.setEkKuralCozumleyici(this.ekUretici);
            List<EkUretimBileseni> bilesenler = this.kuralKelimesiCozumleyici.cozumle(uretimKurali.getValue());
            ek.setUretimBilesenleri(bilesenler);
            List<EkOzelDurumu> ozelDurumlar = this.ozelDurumlariOku(ekElement);
            ek.setOzelDurumlar(ozelDurumlar);
            this.ekOzellikleriBelirle(ek, ekElement);
            ek.setSesliIleBaslayabilir(this.ekUretici.sesliIleBaslayabilir(bilesenler));
            ek.baslangicHarfleriEkle(this.ekUretici.olasiBaslangicHarfleri(bilesenler));
            for (EkOzelDurumu oz : ozelDurumlar) {
                ek.baslangicHarfleriEkle(this.ekUretici.olasiBaslangicHarfleri(oz.uretimBilesenleri()));
            }
        }
        log.fine("ek olusumu sonlandi.");
    }

    private void ekOzellikleriBelirle(Ek ek, Element ekElement) {
        List<Element> ozellikler = XmlYardimcisi.elemanlar(ekElement, "ozellik");
        for (Element element : ozellikler) {
            String ozellik = element.getTextContent().trim();
            if (ozellik.equals("HAL")) {
                ek.setHalEki(true);
                continue;
            }
            if (!ozellik.equals("IYELIK")) continue;
            ek.setIyelikEki(true);
        }
    }

    private List<EkOzelDurumu> ozelDurumlariOku(Element ekElement) {
        ArrayList<EkOzelDurumu> ozelDurumlar = new ArrayList<EkOzelDurumu>();
        List<Element> ozelDurumlarXml = XmlYardimcisi.elemanlar(ekElement, "ozel-durum");
        if (ozelDurumlarXml == null) {
            return Collections.emptyList();
        }
        for (Element element : ozelDurumlarXml) {
            List<Element> oneklerElements;
            String ozelDurumAdi = element.getAttribute("ad");
            EkOzelDurumu oz = this.ekOzelDurumUretici.uret(ozelDurumAdi);
            Attr uretimKurali = element.getAttributeNode("uretim");
            if (uretimKurali != null) {
                oz.setEkKuralCozumleyici(this.ekUretici);
                oz.setUretimBilesenleri(this.kuralKelimesiCozumleyici.cozumle(uretimKurali.getValue()));
            }
            if ((oneklerElements = XmlYardimcisi.elemanlar(element, "on-ek")) != null) {
                HashSet<Ek> onekler = new HashSet<Ek>();
                for (Element onekEl : oneklerElements) {
                    String onekAdi = onekEl.getTextContent();
                    onekler.add(this.ekler.get(onekAdi));
                }
                oz.setOnEkler(onekler);
            }
            ozelDurumlar.add(oz);
        }
        return ozelDurumlar;
    }

    private List<Ek> ardisilEkleriOlustur(Ek anaEk, Element ekElement) {
        Ek ek;
        HashSet<Ek> ardisilEkSet = new HashSet<Ek>();
        Element ardisilEklerEl = XmlYardimcisi.ilkEleman(ekElement, "ardisil-ekler");
        if (ardisilEklerEl == null) {
            return Collections.emptyList();
        }
        List<Element> tekArdisilEkler = XmlYardimcisi.elemanlar(ardisilEklerEl, "aek");
        for (Element element : tekArdisilEkler) {
            String ekAdi = element.getTextContent();
            ek = this.ekler.get(ekAdi);
            if (ek == null) {
                throw new EkKonfigurasyonHatasi(anaEk.ad() + " icin ardisil ek bulunamiyor! " + ekAdi);
            }
            ardisilEkSet.add(ek);
        }
        List<Element> kumeEkler = XmlYardimcisi.elemanlar(ardisilEklerEl, "kume");
        for (Element element : kumeEkler) {
            String kumeAdi = element.getTextContent();
            Set<Ek> kumeEkleri = this.ekKumeleri.get(kumeAdi);
            if (kumeEkleri == null) {
                throw new EkKonfigurasyonHatasi("kume bulunamiyor..." + kumeAdi);
            }
            ardisilEkSet.addAll(kumeEkleri);
        }
        Attr attr = ardisilEklerEl.getAttributeNode("kopya-ek");
        if (attr != null) {
            String kopyaEkadi = attr.getValue();
            ek = this.ekler.get(kopyaEkadi);
            if (ek == null) {
                throw new EkKonfigurasyonHatasi(anaEk.ad() + " icin kopyalanacak ek bulunamiyor! " + kopyaEkadi);
            }
            ardisilEkSet.addAll(ek.ardisilEkler());
        }
        ArrayList<Ek> ardisilEkler = new ArrayList<Ek>(ardisilEkSet.size());
        Element oncelikliEklerEl = XmlYardimcisi.ilkEleman(ekElement, "oncelikli-ekler");
        if (oncelikliEklerEl != null) {
            List<Element> oncelikliEkler = XmlYardimcisi.elemanlar(oncelikliEklerEl, "oek");
            for (Element element : oncelikliEkler) {
                String ekAdi = element.getTextContent();
                Ek ek2 = this.ekler.get(ekAdi);
                if (ek2 == null) {
                    throw new EkKonfigurasyonHatasi(anaEk.ad() + " icin oncelikli ek bulunamiyor! " + ekAdi);
                }
                if (ardisilEkSet.contains(ek2)) {
                    ardisilEkler.add(ek2);
                    ardisilEkSet.remove(ek2);
                    continue;
                }
                log.warning(anaEk.ad() + "icin oncelikli ek:" + ekAdi + " bu ekin ardisil eki degil!");
            }
        }
        ardisilEkler.addAll(ardisilEkSet);
        return ardisilEkler;
    }
}

