/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi.ek;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.ek.EkKuralBilgisi;
import net.zemberek.yapi.ek.EkUretimBileseni;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EkKuralKelimesiCozumleyici {
    private Alfabe alfabe;
    private EkKuralBilgisi ekKuralBilgisi;

    public EkKuralKelimesiCozumleyici(Alfabe alfabe, EkKuralBilgisi ekKuralBilgisi) {
        this.alfabe = alfabe;
        this.ekKuralBilgisi = ekKuralBilgisi;
    }

    public List<EkUretimBileseni> cozumle(String uretimKelimesi) {
        if (uretimKelimesi == null || uretimKelimesi.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<EkUretimBileseni> bilesenler = new ArrayList<EkUretimBileseni>();
        BilesenIterator it = new BilesenIterator(uretimKelimesi.trim().replaceAll("[ ]", ""));
        while (it.hasNext()) {
            bilesenler.add((EkUretimBileseni)it.next());
        }
        return bilesenler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BilesenIterator
    implements Iterator<EkUretimBileseni> {
        private int pointer;
        private final String uretimKelimesi;

        public BilesenIterator(String uretimKelimesi) {
            this.uretimKelimesi = uretimKelimesi;
        }

        @Override
        public boolean hasNext() {
            return this.uretimKelimesi != null && this.pointer < this.uretimKelimesi.length();
        }

        @Override
        public EkUretimBileseni next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("bilesen kalmadi!");
            }
            char p = this.uretimKelimesi.charAt(this.pointer++);
            if (EkKuralKelimesiCozumleyici.this.ekKuralBilgisi.harfKuralKarakterleri().contains(Character.valueOf(p))) {
                if (this.pointer == this.uretimKelimesi.length()) {
                    throw new IllegalArgumentException(p + " kuralindan sonra normal harf bekleniyordu!");
                }
                char h = this.uretimKelimesi.charAt(this.pointer++);
                if (EkKuralKelimesiCozumleyici.this.ekKuralBilgisi.sesliKuralKarakterleri().contains(Character.valueOf(h))) {
                    throw new IllegalArgumentException(p + " kuralindan sonra sesli uretim kurali gelemez:" + h);
                }
                return new EkUretimBileseni(EkKuralKelimesiCozumleyici.this.ekKuralBilgisi.karakterKuralTablosu().get(Character.valueOf(p)), EkKuralKelimesiCozumleyici.this.alfabe.harf(h));
            }
            if (EkKuralKelimesiCozumleyici.this.ekKuralBilgisi.sesliKuralKarakterleri().contains(Character.valueOf(p))) {
                return new EkUretimBileseni(EkKuralKelimesiCozumleyici.this.ekKuralBilgisi.karakterKuralTablosu().get(Character.valueOf(p)), Alfabe.TANIMSIZ_HARF);
            }
            if (EkKuralKelimesiCozumleyici.this.alfabe.harf(p) != null && Character.isLowerCase(p)) {
                return new EkUretimBileseni(EkKuralKelimesiCozumleyici.this.ekKuralBilgisi.harfEklemeKurali(), EkKuralKelimesiCozumleyici.this.alfabe.harf(p));
            }
            throw new IllegalArgumentException(p + "  simgesi cozumlenemiyor.. kelime:" + this.uretimKelimesi);
        }

        @Override
        public void remove() {
        }
    }
}

