/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.zemberek.araclar.Kayitci;
import net.zemberek.bilgi.KaynakYukleyici;
import net.zemberek.bilgi.ZemberekAyarlari;
import net.zemberek.bilgi.araclar.DuzYaziKokOkuyucu;
import net.zemberek.bilgi.araclar.IkiliKokOkuyucu;
import net.zemberek.bilgi.araclar.IkiliKokYazici;
import net.zemberek.bilgi.kokler.AgacSozluk;
import net.zemberek.bilgi.kokler.Sozluk;
import net.zemberek.islemler.BasitDenetlemeCebi;
import net.zemberek.islemler.DenetlemeCebi;
import net.zemberek.islemler.cozumleme.CozumlemeYardimcisi;
import net.zemberek.istatistik.BinaryIstatistikOkuyucu;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.DilAyarlari;
import net.zemberek.yapi.DilBilgisi;
import net.zemberek.yapi.Heceleyici;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.ek.EkKuralKelimesiCozumleyici;
import net.zemberek.yapi.ek.EkYonetici;
import net.zemberek.yapi.ek.XmlEkOkuyucu;
import net.zemberek.yapi.kok.KokOzelDurumBilgisi;

public class TurkceDilBilgisi
implements DilBilgisi {
    private DilAyarlari dilAyarlari;
    private String dilAdi;
    private Alfabe alfabe;
    private Sozluk sozluk;
    private DenetlemeCebi cep;
    private CozumlemeYardimcisi yardimci;
    private EkYonetici ekYonetici;
    private KokOzelDurumBilgisi ozelDurumBilgisi;
    private Heceleyici heceleyici;
    private static Logger logger = Kayitci.kayitciUret(TurkceDilBilgisi.class);
    private final String bilgiDizini;
    private final String alfabeDosyaAdi;
    private final String ekDosyaAdi;
    private final String kokDosyaAdi;
    private final String cepDosyaAdi;
    private final String kokIstatistikDosyaAdi;
    private boolean cepKullan = true;

    public TurkceDilBilgisi(DilAyarlari dilAyarlari) {
        this.dilAyarlari = dilAyarlari;
        this.dilAdi = dilAyarlari.ad();
        this.bilgiDizini = "kaynaklar/" + dilAyarlari.locale().getLanguage() + "/bilgi/";
        this.alfabeDosyaAdi = this.dosyaAdiUret("harf", "txt");
        this.ekDosyaAdi = this.dosyaAdiUret("ek", "xml");
        this.kokDosyaAdi = this.dosyaAdiUret("kokler", "bin");
        this.cepDosyaAdi = this.dosyaAdiUret("kelime_cebi", "txt");
        this.kokIstatistikDosyaAdi = this.dosyaAdiUret("kok_istatistik", "bin");
    }

    public TurkceDilBilgisi(DilAyarlari dilAyarlari, ZemberekAyarlari zemberekAyarlari) {
        this(dilAyarlari);
        this.cepKullan = zemberekAyarlari.cepKullan();
    }

    private String dosyaAdiUret(String kok, String uzanti) {
        return this.bilgiDizini + kok + '_' + this.dilAyarlari.locale().getLanguage() + '.' + uzanti;
    }

    public Alfabe alfabe() {
        if (this.alfabe != null) {
            return this.alfabe;
        }
        try {
            logger.fine("Alfabe uretiliyor:" + this.dilAdi);
            Class clazz = this.dilAyarlari.alfabeSinifi();
            Constructor c = clazz.getConstructor(String.class, String.class);
            this.alfabe = (Alfabe)c.newInstance(this.alfabeDosyaAdi, this.dilAyarlari.locale().getLanguage());
        }
        catch (Exception e) {
            logger.severe("Alfabe uretilemiyor. muhtemel dosya erisim hatasi." + e.getMessage());
        }
        return this.alfabe;
    }

    public EkYonetici ekler() {
        if (this.ekYonetici != null) {
            return this.ekYonetici;
        }
        this.alfabe();
        try {
            EkKuralKelimesiCozumleyici kuralCozumleyici = new EkKuralKelimesiCozumleyici(this.alfabe, this.dilAyarlari.ekKuralBilgisi());
            XmlEkOkuyucu ekOkuyucu = new XmlEkOkuyucu(this.ekDosyaAdi, this.dilAyarlari.ekUretici(this.alfabe), this.dilAyarlari.ekOzelDurumUretici(this.alfabe), kuralCozumleyici);
            logger.fine("Ek yonetici uretiliyor:" + this.dilAdi);
            Class clazz = this.dilAyarlari.ekYoneticiSinifi();
            Constructor c = clazz.getConstructor(Map.class, XmlEkOkuyucu.class);
            this.ekYonetici = (EkYonetici)c.newInstance(this.dilAyarlari.baslangiEkAdlari(), ekOkuyucu);
        }
        catch (Exception e) {
            logger.severe("ek yonetici sinif uretilemiyor." + e.getMessage());
        }
        return this.ekYonetici;
    }

    public Sozluk kokler() {
        if (this.sozluk != null) {
            return this.sozluk;
        }
        if (!new KaynakYukleyici().kaynakMevcutmu(this.kokDosyaAdi)) {
            logger.warning("binary kok dosyasi bulunamadi. proje icerisinden calisildigi varsayilarak \ncalisilan dizine goreceli olarak '" + this.kokDosyaAdi + "' dosyasi uretilmeye calisacak.\n" + "eger duz yazki kok bilgilerine erisim saglanamazsa sistem kok bilgisine uretemeycektir. ");
            try {
                this.ikiliKokDosyasiUret();
            }
            catch (IOException e) {
                logger.severe("kok bilgilerine erisim saglanamadigindan uygulama calismaya devam edemez." + e.getMessage());
                return null;
            }
        }
        this.kokOzelDurumlari();
        logger.fine("Ikili okuyucu uretiliyor:");
        try {
            IkiliKokOkuyucu okuyucu = new IkiliKokOkuyucu(this.kokDosyaAdi, this.ozelDurumBilgisi);
            logger.fine("Sozluk ve agac uretiliyor:" + this.dilAdi);
            this.sozluk = new AgacSozluk(okuyucu, this.alfabe, this.ozelDurumBilgisi);
        }
        catch (IOException e) {
            logger.severe("sozluk uretilemiyor." + e.getMessage());
        }
        return this.sozluk;
    }

    public KokOzelDurumBilgisi kokOzelDurumlari() {
        if (this.ozelDurumBilgisi != null) {
            return this.ozelDurumBilgisi;
        }
        this.ekler();
        try {
            Class clazz = this.dilAyarlari.kokOzelDurumBilgisiSinifi();
            Constructor c = clazz.getConstructor(EkYonetici.class, Alfabe.class);
            this.ozelDurumBilgisi = (KokOzelDurumBilgisi)c.newInstance(this.ekYonetici, this.alfabe);
        }
        catch (Exception e) {
            logger.severe("kok ozel durum bilgi nesnesi uretilemiyor." + e.getMessage());
        }
        return this.ozelDurumBilgisi;
    }

    public DenetlemeCebi denetlemeCebi() {
        if (!this.cepKullan) {
            logger.info("denetlemeCebi kullanilmayacak.");
            return null;
        }
        if (this.cep != null) {
            return this.cep;
        }
        try {
            this.cep = new BasitDenetlemeCebi(this.cepDosyaAdi);
        }
        catch (IOException e) {
            logger.warning("denetlemeCebi dosyasina (" + this.cepDosyaAdi + ") erisilemiyor. sistem denetlemeCebi kullanmayacak.");
            this.cep = null;
        }
        return this.cep;
    }

    public Heceleyici heceBulucu() {
        if (this.heceleyici != null) {
            return this.heceleyici;
        }
        this.alfabe();
        Class clazz = this.dilAyarlari.heceleyiciSinifi();
        try {
            Constructor c = clazz.getConstructor(Alfabe.class);
            this.heceleyici = (Heceleyici)c.newInstance(this.alfabe);
        }
        catch (Exception e) {
            try {
                Constructor c = clazz.getConstructor(new Class[0]);
                this.heceleyici = (Heceleyici)c.newInstance(new Object[0]);
            }
            catch (Exception e2) {
                logger.warning("heceleyici nesnesi uretilemiyor. heceleme islemi basarisiz olacak." + e2.getMessage());
            }
        }
        return this.heceleyici;
    }

    public CozumlemeYardimcisi cozumlemeYardimcisi() {
        if (this.yardimci != null) {
            return this.yardimci;
        }
        this.alfabe();
        try {
            Class clazz = this.dilAyarlari.cozumlemeYardimcisiSinifi();
            Constructor c = clazz.getConstructor(Alfabe.class);
            this.yardimci = (CozumlemeYardimcisi)c.newInstance(this.alfabe);
        }
        catch (Exception e) {
            logger.severe("cozumleme yardimcisi nesnesi uretilemiyor." + e.getMessage());
        }
        return this.yardimci;
    }

    public void ikiliKokDosyasiUret() throws IOException {
        this.alfabe();
        this.ekler();
        this.kokOzelDurumlari();
        logger.info("Ikili sozluk dosyasi olusturuluyor...");
        ArrayList<Kok> tumKokler = new ArrayList<Kok>();
        for (String dosyaAdi : this.dilAyarlari.duzYaziKokDosyalari()) {
            DuzYaziKokOkuyucu okuyucu = new DuzYaziKokOkuyucu(dosyaAdi, this.ozelDurumBilgisi, this.alfabe, this.dilAyarlari.kokTipiAdlari());
            List<Kok> list = okuyucu.hepsiniOku();
            logger.info("Okunan kok sayisi: " + list.size());
            tumKokler.addAll(list);
        }
        logger.info("Toplam kok sayisi:" + tumKokler.size());
        AgacSozluk sozluk = new AgacSozluk(tumKokler, this.alfabe, this.ozelDurumBilgisi);
        if (new File(this.kokIstatistikDosyaAdi).exists()) {
            BinaryIstatistikOkuyucu istatistikOkuyucu = new BinaryIstatistikOkuyucu();
            istatistikOkuyucu.initialize(this.kokIstatistikDosyaAdi);
            istatistikOkuyucu.oku(sozluk);
        } else {
            logger.warning("istatistik dosyasina erisilemedi, kok dosyasi istatistik bilgisi icermeyecek." + this.kokIstatistikDosyaAdi);
        }
        IkiliKokYazici ozelYazici = new IkiliKokYazici(this.kokDosyaAdi);
        ozelYazici.yaz(tumKokler);
    }

    public static void main(String[] args) throws Exception {
        Class<?> c = Class.forName("net.zemberek.tr.yapi.TurkiyeTurkcesi");
        if (args.length > 0) {
            String dilAyarSinifi = args[0];
            c = Class.forName(dilAyarSinifi);
        }
        new TurkceDilBilgisi((DilAyarlari)c.newInstance()).ikiliKokDosyasiUret();
    }
}

