/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi;

import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.kok.KokOzelDurumTipi;
import net.zemberek.yapi.kok.KokOzelDurumu;

public class Kok {
    private static final KokOzelDurumu[] BOS_OZEL_DURUM_DIZISI = new KokOzelDurumu[0];
    public static final Kok BOS_KOK = new Kok("", KelimeTipi.ISIM);
    private int indeks;
    private String asil;
    private String icerik;
    protected KelimeTipi tip;
    private KokOzelDurumu[] ozelDurumlar = BOS_OZEL_DURUM_DIZISI;
    private int frekans;

    public boolean ozelDurumVarmi() {
        return this.ozelDurumlar.length > 0;
    }

    public KokOzelDurumu[] ozelDurumDizisi() {
        return this.ozelDurumlar;
    }

    public boolean ozelDurumIceriyormu(KokOzelDurumTipi tip) {
        for (KokOzelDurumu oz : this.ozelDurumlar) {
            if (oz.indeks() != tip.indeks()) continue;
            return true;
        }
        return false;
    }

    public void ozelDurumEkle(KokOzelDurumu ozelDurum) {
        if (this.ozelDurumlar.length == 0) {
            this.ozelDurumlar = new KokOzelDurumu[1];
            this.ozelDurumlar[0] = ozelDurum;
        } else {
            if (this.ozelDurumIceriyormu(ozelDurum.tip())) {
                return;
            }
            KokOzelDurumu[] yeni = new KokOzelDurumu[this.ozelDurumlar.length + 1];
            for (int i = 0; i < this.ozelDurumlar.length; ++i) {
                yeni[i] = this.ozelDurumlar[i];
            }
            yeni[this.ozelDurumlar.length] = ozelDurum;
            this.ozelDurumlar = yeni;
        }
    }

    public void ozelDurumCikar(KokOzelDurumTipi tip) {
        if (!this.ozelDurumIceriyormu(tip)) {
            return;
        }
        KokOzelDurumu[] yeni = new KokOzelDurumu[this.ozelDurumlar.length - 1];
        int j = 0;
        for (KokOzelDurumu oz : this.ozelDurumlar) {
            if (oz.tip().equals(tip)) continue;
            yeni[j++] = oz;
        }
        this.ozelDurumlar = yeni;
    }

    public Kok(String icerik) {
        this.icerik = icerik;
    }

    public Kok(String icerik, KelimeTipi tip) {
        this.icerik = icerik;
        this.tip = tip;
    }

    public String toString() {
        String strOzel = "";
        for (KokOzelDurumu ozelDurum : this.ozelDurumlar) {
            if (ozelDurum == null) continue;
            strOzel = strOzel + ozelDurum.kisaAd() + " ";
        }
        if (this.tip != null) {
            return this.icerik + " " + (Object)((Object)this.tip) + " " + strOzel;
        }
        return this.icerik;
    }

    public HarfDizisi ozelDurumUygula(Alfabe alfabe, Ek ek) {
        HarfDizisi dizi = new HarfDizisi(this.icerik, alfabe);
        for (KokOzelDurumu ozelDurum : this.ozelDurumlar) {
            if (ozelDurum.yapiBozucumu() && ozelDurum.olusabilirMi(ek)) {
                ozelDurum.uygula(dizi);
            }
            if (ozelDurum.olusabilirMi(ek) || !ozelDurum.ekKisitlayiciMi()) continue;
            return null;
        }
        return dizi;
    }

    public boolean yapiBozucuOzelDurumVarmi() {
        if (this.ozelDurumlar.length == 0) {
            return false;
        }
        for (KokOzelDurumu ozelDurum : this.ozelDurumlar) {
            if (!ozelDurum.yapiBozucumu()) continue;
            return true;
        }
        return false;
    }

    public String asilIcerikUret(Alfabe alfabe) {
        if (this.asil != null) {
            return this.asil;
        }
        if (this.icerik == null || this.icerik.length() == 0) {
            return "";
        }
        if (this.tip == KelimeTipi.OZEL) {
            if (this.icerik.length() > 1) {
                return this.icerik.substring(0, 1).toUpperCase(alfabe.locale) + this.icerik.substring(1);
            }
            return this.icerik.toUpperCase(alfabe.locale);
        }
        return this.icerik;
    }

    public final KelimeTipi tip() {
        return this.tip;
    }

    public final void setTip(KelimeTipi tip) {
        this.tip = tip;
    }

    public final void setIcerik(String icerik) {
        this.icerik = icerik;
    }

    public final String icerik() {
        return this.icerik;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Kok kok = (Kok)o;
        if (this.icerik != null ? !this.icerik.equals(kok.icerik) : kok.icerik != null) {
            return false;
        }
        if (this.ozelDurumlar != null ? !this.ozelDurumlar.equals(kok.ozelDurumlar) : kok.ozelDurumlar != null) {
            return false;
        }
        return !(this.tip != null ? !this.tip.equals((Object)kok.tip) : kok.tip != null);
    }

    public int hashCode() {
        int result = this.icerik != null ? this.icerik.hashCode() : 0;
        result = 29 * result + (this.tip != null ? this.tip.hashCode() : 0);
        result = 29 * result + (this.ozelDurumlar != null ? this.ozelDurumlar.hashCode() : 0);
        return result;
    }

    public int getIndeks() {
        return this.indeks;
    }

    public void setIndeks(int indeks) {
        this.indeks = indeks;
    }

    public void setFrekans(int kokIstatistigi) {
        this.frekans = kokIstatistigi;
    }

    public int getFrekans() {
        return this.frekans;
    }

    public String asil() {
        return this.asil;
    }

    public void setAsil(String asil) {
        this.asil = asil;
    }
}

