/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.istatistik;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import net.zemberek.araclar.IstatistikAraclari;
import net.zemberek.istatistik.EkIstatistikleri;
import net.zemberek.istatistik.EkZinciri;
import net.zemberek.istatistik.GenelKokIstatistikBilgisi;
import net.zemberek.istatistik.Hece;
import net.zemberek.istatistik.HeceIstatistikleri;
import net.zemberek.istatistik.IkiliIstatistikleri;
import net.zemberek.istatistik.IstatistikRaporlayici;
import net.zemberek.istatistik.Istatistikler;
import net.zemberek.istatistik.KarakterIstatistikleri;
import net.zemberek.istatistik.KelimeBilgisi;
import net.zemberek.istatistik.KelimeIstatistikleri;
import net.zemberek.istatistik.KelimeZinciri;
import net.zemberek.istatistik.KokIstatistikleri;

public abstract class TemelRaporlayici
implements IstatistikRaporlayici {
    protected Istatistikler istatistikler = null;

    public void raporla(OutputStream out, String encoding) {
        try {
            int i;
            KelimeZinciri zincir;
            int i2;
            int i3;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, encoding));
            KokIstatistikleri kokIst = this.istatistikler.getKokIstatistikleri();
            HeceIstatistikleri heceIst = this.istatistikler.getHeceIstatistikleri();
            EkIstatistikleri ekIst = this.istatistikler.getEkIstatistikleri();
            KarakterIstatistikleri karIst = this.istatistikler.getKarakterIstatistikleri();
            KelimeIstatistikleri kelimeIst = this.istatistikler.getKelimeIstatistikleri();
            IkiliIstatistikleri ikiliIst = this.istatistikler.getIkiliIstatistikleri();
            IkiliIstatistikleri kokIkiliIst = this.istatistikler.getKokIkiliIstatistikleri();
            IkiliIstatistikleri heceIkiliIst = this.istatistikler.getHeceIkiliIstatistikleri();
            KelimeIstatistikleri ikiliHarfIst = this.istatistikler.getIkiliHarfIstatistikleri();
            List<GenelKokIstatistikBilgisi> kokListesi = kokIst.getKokListesi();
            if (kokListesi == null) {
                return;
            }
            writer.write("Karakter istatistikleri:\n");
            writer.write("------------------------");
            writer.write(karIst.toString());
            writer.write("\nGenel istatistikler:\n");
            writer.write("------------------------\n");
            writer.write("\nEn cok kullanilan ilk kac kok toplam koklerin yuzde kacini olusturuyor?:\n");
            for (int i4 = 0; i4 < kokIst.getAraToplamSayaci(); ++i4) {
                writer.write("-> ilk " + kokIst.getKontrolDizisi()[i4] + " kok, toplam\u0131n %" + kokIst.getKokKapsamaYuzdeleri()[i4] + "\n");
            }
            writer.write("\n");
            writer.write("\nEk miktari kullanim oranlari:\n");
            int[] toplamEkUzunlukSayilari = kokIst.getToplamEkUzunlukSayilari();
            long toplamKelime = kokIst.getToplamKelime();
            long toplamKokSayisi = kokIst.getToplamKokSayisi();
            for (int i5 = 0; i5 < toplamEkUzunlukSayilari.length; ++i5) {
                writer.write(i5 + " adet ek'e sahip kelime say\u0131s\u0131: " + toplamEkUzunlukSayilari[i5] + " Oran: %" + IstatistikAraclari.yuzdeHesaplaStr(toplamEkUzunlukSayilari[i5], toplamKelime) + "\n");
            }
            writer.write("\n");
            writer.write("\nCozulebilen Kelime tip dagilimi (isaretleme eksikligi nedeniyle isim-fiil harici hatali olabilir):\n");
            writer.write("Toplam kelime say\u0131s\u0131: " + toplamKelime + "\n");
            writer.write("Toplam isim sayisi: " + kokIst.getToplamIsimSayisi() + "  Oran: %" + IstatistikAraclari.yuzdeHesaplaStr(kokIst.getToplamIsimSayisi(), toplamKelime) + " Ortalama Boy : " + IstatistikAraclari.df.format(kokIst.getOrtalamaIsimUzunlugu()) + "\n");
            writer.write("Toplam s\u0131fat sayisi: " + kokIst.getToplamSifatSayisi() + "  Oran: %" + IstatistikAraclari.yuzdeHesaplaStr(kokIst.getToplamSifatSayisi(), toplamKelime) + "\n");
            writer.write("Toplam fiil sayisi: " + kokIst.getToplamFiilSayisi() + "  Oran: %" + IstatistikAraclari.yuzdeHesaplaStr(kokIst.getToplamFiilSayisi(), toplamKelime) + " Ortalama Boy : " + IstatistikAraclari.df.format(kokIst.getOrtalamaFiilUzunlugu()) + "\n");
            writer.write("Toplam Sayi sayisi: " + kokIst.getToplamSayiSayisi() + "  Oran: %" + IstatistikAraclari.yuzdeHesaplaStr(kokIst.getToplamSayiSayisi(), toplamKelime) + "\n");
            writer.write("Toplam kok sayisi: " + kokIst.getToplamKokSayisi());
            writer.write("\nToplam isim k\u00f6k sayisi: " + kokIst.getToplamIsimKokSayisi() + "  Oran: %" + IstatistikAraclari.yuzdeHesaplaStr(kokIst.getToplamIsimKokSayisi(), toplamKokSayisi) + "\n");
            writer.write("Toplam s\u0131fat k\u00f6k sayisi: " + kokIst.getToplamSifatKokSayisi() + "  Oran: %" + IstatistikAraclari.yuzdeHesaplaStr(kokIst.getToplamSifatKokSayisi(), toplamKokSayisi) + "\n");
            writer.write("Toplam fiil k\u00f6k sayisi: " + kokIst.getToplamFiilKokSayisi() + "  Oran: %" + IstatistikAraclari.yuzdeHesaplaStr(kokIst.getToplamFiilKokSayisi(), toplamKokSayisi) + "\n");
            writer.write("\n\n");
            writer.write("\nEn cok kullanilan kelimeler:\n");
            int sayac = 1;
            int toplam = 0;
            List<KelimeBilgisi> ikiliHarfler = kelimeIst.getKelimeListesi();
            int limit = this.istatistikler.getKelimeLimit() > ikiliHarfler.size() ? ikiliHarfler.size() : this.istatistikler.getKokLimit();
            for (i3 = 0; i3 < limit; ++i3) {
                KelimeBilgisi kelime = ikiliHarfler.get(i3);
                writer.write(sayac++ + ". " + "[ " + kelime.kelime + " ]" + "  Kullanim: " + kelime.miktar + " Oran: % " + IstatistikAraclari.yuzdeHesaplaStr(kelime.miktar, toplamKelime) + " Kapsama: % " + IstatistikAraclari.yuzdeHesaplaStr(toplam += kelime.miktar, toplamKelime) + "\n");
            }
            writer.write("\n\n");
            writer.write("\nEn cok kullanilan kok ve bagli ek oranlari:\n");
            sayac = 1;
            limit = this.istatistikler.getKokLimit() > kokListesi.size() ? kokListesi.size() : this.istatistikler.getKokLimit();
            for (i3 = 0; i3 < limit; ++i3) {
                String report = "";
                GenelKokIstatistikBilgisi istatistik = kokListesi.get(i3);
                List<EkZinciri> ekler = istatistik.getEkListesi();
                writer.write(sayac++ + ". " + "<" + istatistik.getKok().icerik() + ">" + " Kullan\u0131m : " + istatistik.getKullanimSayisi() + " Oran : %" + IstatistikAraclari.yuzdeHesaplaStr(istatistik.getKullanimSayisi(), toplamKelime) + " Ortalama kelime uzunlu\u011fu : " + IstatistikAraclari.df.format(istatistik.getOrtalamaKelimeUzunlugu()) + "\n");
                double ekKapsam = 0.0;
                for (int j = 0; j < ekler.size(); ++j) {
                    EkZinciri zincir2 = ekler.get(j);
                    if (!(zincir2.getKullanimFrekansi() > 1.0)) continue;
                    writer.write(j + ". -- " + zincir2 + "   Oran : %" + IstatistikAraclari.df.format(zincir2.getKullanimFrekansi()) + " Toplam: %" + IstatistikAraclari.df.format(ekKapsam += zincir2.getKullanimFrekansi()) + "\n");
                }
                writer.write("----> Kullan\u0131m oran\u0131 %0.1'den fazla olan ek zincirlerinin kapsam oran\u0131: %" + IstatistikAraclari.df.format(ekKapsam) + "\n\n");
                writer.write(report);
            }
            writer.write(ekIst.toString());
            writer.write("\n\n");
            List<KelimeZinciri> list = ikiliIst.getSiraliKelimeZincirleri();
            limit = list.size() < this.istatistikler.getKokLimit() ? list.size() : this.istatistikler.getKokLimit();
            for (i2 = 0; i2 < limit; ++i2) {
                zincir = list.get(i2);
                writer.write(i2 + 1 + ". " + zincir.toString() + "\n");
            }
            writer.write("\n\n");
            list = kokIkiliIst.getSiraliKelimeZincirleri();
            limit = list.size() < this.istatistikler.getKokLimit() ? list.size() : this.istatistikler.getKokLimit();
            for (i2 = 0; i2 < limit; ++i2) {
                zincir = list.get(i2);
                writer.write(i2 + 1 + ". " + zincir.toString() + "\n");
            }
            writer.write("\n\n");
            list = heceIkiliIst.getSiraliKelimeZincirleri();
            limit = list.size() < this.istatistikler.getKokLimit() ? list.size() : this.istatistikler.getKokLimit();
            for (i2 = 0; i2 < limit; ++i2) {
                zincir = list.get(i2);
                writer.write(i2 + 1 + ". " + zincir.toString() + "\n");
            }
            long araToplam = 0L;
            for (i = 0; i < heceIst.getHeceListesi().size() && i < this.istatistikler.getHeceLimit(); ++i) {
                Hece hece = heceIst.getHeceListesi().get(i);
                writer.write(i + ". " + hece.getHece() + " [" + hece.getKullanim() + "] Oran(%): " + IstatistikAraclari.yuzdeHesaplaStr(hece.getKullanim(), heceIst.getHeceSayisi()) + " AraToplam(%): " + IstatistikAraclari.yuzdeHesaplaStr(araToplam += hece.getKullanim(), heceIst.getHeceSayisi()) + "\n");
                if (i > 3000) break;
            }
            sayac = 1;
            toplam = 0;
            ikiliHarfler = ikiliHarfIst.getKelimeListesi();
            for (i = 0; i < ikiliHarfler.size(); ++i) {
                KelimeBilgisi kelime = ikiliHarfler.get(i);
                toplam += kelime.miktar;
                writer.write(sayac++ + ". " + "[ " + kelime.kelime + " ]" + " Kullanim: " + kelime.miktar + "\n");
            }
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

