/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.istatistik;

import java.util.ArrayList;
import java.util.Collections;
import net.zemberek.araclar.IstatistikAraclari;

public class KarakterIstatistikleri {
    private int karakterSayisi = 0;
    private int harfSayisi = 0;
    private int kelimeSayisi = 0;
    private int cumleSayisi = 0;
    private int rakamSayisi = 0;
    private int boslukSayisi = 0;
    private int virgulSayisi = 0;
    private int noktaSayisi = 0;
    private int unlemSayisi = 0;
    private int ikinoktaSayisi = 0;
    private int noktaliVirgulSayisi;
    private int buyukharfSayisi;
    private int[] harfDagilimi = new int[500];
    private int[] rakamDagilimi = new int[10];
    private boolean kelimeBasi = false;
    private boolean cumleBasi = false;
    private double ortalamaKelimeBoyu = 0.0;
    private double ortalamaCumleBoyu = 0.0;

    public void processChar(char ch) {
        ++this.karakterSayisi;
        if (Character.isLetter(ch)) {
            if (Character.isUpperCase(ch)) {
                ++this.buyukharfSayisi;
            }
            this.kelimeBasi = true;
            this.cumleBasi = true;
            ++this.harfSayisi;
            char c = ch;
            this.harfDagilimi[c] = this.harfDagilimi[c] + 1;
        } else if (Character.isWhitespace(ch)) {
            ++this.boslukSayisi;
            if (this.kelimeBasi) {
                ++this.kelimeSayisi;
            }
            this.kelimeBasi = false;
        } else if (ch == '.' || ch == '!' || ch == '?') {
            ++this.noktaSayisi;
            if (this.cumleBasi) {
                ++this.cumleSayisi;
            }
            this.cumleBasi = false;
        } else if (Character.isDigit(ch)) {
            ++this.rakamSayisi;
            int n = Character.digit(ch, 10);
            this.rakamDagilimi[n] = this.rakamDagilimi[n] + 1;
        }
    }

    public void tamamla() {
        if (this.kelimeSayisi > 0) {
            this.ortalamaKelimeBoyu = (double)this.harfSayisi / (double)this.kelimeSayisi;
        }
        if (this.cumleSayisi > 0) {
            this.ortalamaCumleBoyu = (double)this.kelimeSayisi / (double)this.cumleSayisi;
        }
    }

    public String toString() {
        String str = "\nKarakter Sayisi     : " + this.karakterSayisi + "\nHarf Sayisi         : " + this.harfSayisi + "\nKelime Sayisi       : " + this.kelimeSayisi + "\nCumle Sayisi        : " + this.cumleSayisi + "\nBuyuk harf sayisi   : " + this.buyukharfSayisi + "\nBo\u015fluk say\u0131s\u0131       : " + this.boslukSayisi + "\nNokta Sayisi        : " + this.noktaSayisi + "\nRakam Sayisi        : " + this.rakamSayisi + "\nOrtalama Kelime uz. : " + this.ortalamaKelimeBoyu + "\nOrtalama C\u00fcmle uz.  : " + this.ortalamaCumleBoyu;
        long toplamHarf = 0L;
        for (int miktar : this.harfDagilimi) {
            toplamHarf += (long)miktar;
        }
        str = str + "\n\nHarf Dagilimi";
        ArrayList<CharFreq> list = new ArrayList<CharFreq>();
        for (int i = 0; i < this.harfDagilimi.length; ++i) {
            if (this.harfDagilimi[i] <= 0) continue;
            list.add(new CharFreq((char)i, this.harfDagilimi[i]));
        }
        Collections.sort(list);
        for (CharFreq charFreq : list) {
            str = str + "\nHarf " + charFreq.c + ": " + charFreq.i + " %" + IstatistikAraclari.yuzdeHesaplaStr(charFreq.i, toplamHarf);
        }
        str = str + "\n";
        return str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CharFreq
    implements Comparable<CharFreq> {
        char c;
        int i;

        private CharFreq(char c, int i) {
            this.c = c;
            this.i = i;
        }

        @Override
        public int compareTo(CharFreq charFreq) {
            if (this.i < charFreq.i) {
                return 1;
            }
            if (this.i > charFreq.i) {
                return -1;
            }
            return 0;
        }
    }
}

