/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.istatistik;

import java.util.List;
import net.zemberek.islemler.HeceIslemleri;
import net.zemberek.istatistik.EkIstatistikleri;
import net.zemberek.istatistik.GenelKokIstatistikBilgisi;
import net.zemberek.istatistik.HeceIstatistikleri;
import net.zemberek.istatistik.IkiliIstatistikleri;
import net.zemberek.istatistik.KarakterIstatistikleri;
import net.zemberek.istatistik.KelimeIstatistikleri;
import net.zemberek.istatistik.KokIstatistikleri;
import net.zemberek.yapi.DilBilgisi;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.Kok;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Istatistikler {
    private HeceIslemleri heceIslemleri;
    private HeceIstatistikleri heceIstatistikleri = new HeceIstatistikleri();
    private KarakterIstatistikleri karakterIstatistikleri = new KarakterIstatistikleri();
    private KokIstatistikleri kokIstatistikleri = new KokIstatistikleri();
    private EkIstatistikleri ekIstatistikleri = new EkIstatistikleri();
    private KelimeIstatistikleri kelimeIstatistikleri = new KelimeIstatistikleri();
    private KelimeIstatistikleri ikiliHarfIstatistikleri = new KelimeIstatistikleri();
    private IkiliIstatistikleri ikiliIstatistikleri = new IkiliIstatistikleri();
    private IkiliIstatistikleri kokIkiliIstatistikleri = new IkiliIstatistikleri();
    private IkiliIstatistikleri heceIkiliIstatistikleri = new IkiliIstatistikleri();
    private List<Istatistikler> altIstatistikler = null;
    private int kelimeSayisi = 0;
    private int hatalar = 0;
    private int dogrular = 0;
    private int heceLimit = 0;
    private int kokLimit = 0;
    private int kelimeLimit = 0;

    public Istatistikler(DilBilgisi dil) {
        this.heceIslemleri = new HeceIslemleri(dil.alfabe(), dil.heceBulucu());
    }

    public void setLimit(int heceLimit, int kokLimit, int kelimeLimit) {
        this.heceLimit = heceLimit;
        this.kokLimit = kokLimit;
        this.kelimeLimit = kelimeLimit;
    }

    public void kokIstatistikGuncelle(Kok kok, Kelime kelime) {
        this.kokIstatistikleri.sonucGuncelle(kok, kelime);
    }

    public void ekIstatistikleriGuncelle(Kelime kelime) {
        this.ekIstatistikleri.istatistikGuncelle(kelime);
    }

    public void kelimeIstatistikGuncelle(Kelime kelime) {
        this.kelimeIstatistikleri.isle(kelime.icerikStr());
    }

    public void ikiliIstatistikGuncelle(Kelime kelime) {
        this.ikiliIstatistikleri.sonucGuncelle(kelime.icerikStr());
    }

    public void karakterIstatistikGuncelle(char c) {
        this.karakterIstatistikleri.processChar(c);
    }

    public void processChar(char ch) {
        this.karakterIstatistikleri.processChar(ch);
    }

    public List<Istatistikler> getAltIstatistikler() {
        return this.altIstatistikler;
    }

    public void addAltIstatistik(Istatistikler istatistik) {
        this.altIstatistikler.add(istatistik);
    }

    public void removeAltIstatistik(Istatistikler istatistik) {
        this.altIstatistikler.remove(istatistik);
    }

    public HeceIstatistikleri getHeceIstatistikleri() {
        return this.heceIstatistikleri;
    }

    public List<GenelKokIstatistikBilgisi> getKokListesi() {
        return this.kokIstatistikleri.getKokListesi();
    }

    public long getKelimeSayisi() {
        return this.kokIstatistikleri.getToplamKelimeSayisi();
    }

    public void sonlandir() {
        this.kokIstatistikleri.tamamla();
        this.heceIstatistikleri.tamamla();
        this.ekIstatistikleri.tamamla();
        this.karakterIstatistikleri.tamamla();
        this.kelimeIstatistikleri.tamamla();
        this.ikiliIstatistikleri.tamamla();
        this.kokIkiliIstatistikleri.tamamla();
        this.ikiliHarfIstatistikleri.tamamla();
        this.heceIkiliIstatistikleri.tamamla();
    }

    public KokIstatistikleri getKokIstatistikleri() {
        return this.kokIstatistikleri;
    }

    public EkIstatistikleri getEkIstatistikleri() {
        return this.ekIstatistikleri;
    }

    public void hepsiniGuncelle(String giris, Kelime[] kelimeler) {
        if (kelimeler == null) {
            ++this.hatalar;
            return;
        }
        if (kelimeler.length > 0) {
            ++this.dogrular;
            ++this.kelimeSayisi;
            char[] karakterler = giris.toCharArray();
            for (int i = 0; i < karakterler.length; ++i) {
                this.karakterIstatistikleri.processChar(karakterler[i]);
            }
            Kelime kelime = kelimeler[0];
            this.kokIstatistikleri.sonucGuncelle(kelime.kok(), kelime);
            this.ekIstatistikleri.istatistikGuncelle(kelime);
            String[] heceler = this.heceIslemleri.hecele(giris);
            for (int j = 0; j < heceler.length; ++j) {
                this.heceIstatistikleri.guncelle(heceler[j]);
                this.heceIkiliIstatistikleri.sonucGuncelle(heceler[j]);
            }
            this.kelimeIstatistikleri.isle(giris);
            for (int i = 0; i < giris.length() - 2; ++i) {
                this.ikiliHarfIstatistikleri.isle(giris.substring(i, i + 2));
            }
            this.ikiliIstatistikleri.sonucGuncelle(kelime.icerikStr());
            this.kokIkiliIstatistikleri.sonucGuncelle(kelime.kok().icerik());
        }
    }

    public KarakterIstatistikleri getKarakterIstatistikleri() {
        return this.karakterIstatistikleri;
    }

    public KelimeIstatistikleri getKelimeIstatistikleri() {
        return this.kelimeIstatistikleri;
    }

    public int getHeceLimit() {
        return this.heceLimit;
    }

    public void setHeceLimit(int heceLimit) {
        this.heceLimit = heceLimit;
    }

    public int getKelimeLimit() {
        return this.kelimeLimit;
    }

    public void setKelimeLimit(int kelimeLimit) {
        this.kelimeLimit = kelimeLimit;
    }

    public int getKokLimit() {
        return this.kokLimit;
    }

    public void setKokLimit(int kokLimit) {
        this.kokLimit = kokLimit;
    }

    public IkiliIstatistikleri getIkiliIstatistikleri() {
        return this.ikiliIstatistikleri;
    }

    public IkiliIstatistikleri getKokIkiliIstatistikleri() {
        return this.kokIkiliIstatistikleri;
    }

    public KelimeIstatistikleri getIkiliHarfIstatistikleri() {
        return this.ikiliHarfIstatistikleri;
    }

    public IkiliIstatistikleri getHeceIkiliIstatistikleri() {
        return this.heceIkiliIstatistikleri;
    }
}

