/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.istatistik;

import java.io.File;
import java.io.FileFilter;
import net.zemberek.araclar.TimeTracker;
import net.zemberek.araclar.turkce.TurkceMetinOkuyucu;
import net.zemberek.erisim.Zemberek;
import net.zemberek.islemler.cozumleme.CozumlemeSeviyesi;
import net.zemberek.islemler.cozumleme.KelimeCozumleyici;
import net.zemberek.istatistik.BinaryIstatistikYazici;
import net.zemberek.istatistik.DosyaRaporlayici;
import net.zemberek.istatistik.Istatistikler;
import net.zemberek.yapi.DilAyarlari;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.TurkceDilBilgisi;

public class IstatistikToplayici {
    private KelimeCozumleyici cozumleyici;
    private Istatistikler istatistikler;
    private long toplamKelime = 0L;

    public IstatistikToplayici(KelimeCozumleyici cozumleyici, Istatistikler istatistikler) {
        this.cozumleyici = cozumleyici;
        this.istatistikler = istatistikler;
    }

    public void metinIsle(String dosyaAdi) {
        System.out.println("Taranan dosya: " + dosyaAdi);
        TurkceMetinOkuyucu tmo = new TurkceMetinOkuyucu();
        tmo.setStatistics(this.istatistikler);
        String[] tumKelimeler = tmo.MetinOku(dosyaAdi);
        System.out.println("Okunan kelime say\u0131s\u0131: " + tumKelimeler.length);
        for (int i = 0; i < tumKelimeler.length; ++i) {
            try {
                Kelime[] kelimeler;
                if (i > 0 && i % 500 == 0 && i % 20000 == 0) {
                    System.out.println(i);
                }
                if ((kelimeler = this.cozumleyici.cozumle(tumKelimeler[i], CozumlemeSeviyesi.TUM_KOK_VE_EKLER)) == null) continue;
                ++this.toplamKelime;
                this.istatistikler.hepsiniGuncelle(tumKelimeler[i], kelimeler);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(tumKelimeler[i] + " yi \u00e7\u00f6z\u00fcmlerken beklenmeyen hata. " + e.getMessage());
            }
        }
        System.out.println("Bitti.");
    }

    public void publish() {
        this.istatistikler.sonlandir();
    }

    public void klasorIsle(String yol) {
        File[] dosyalar;
        File dir = new File(yol);
        for (File dosya : dosyalar = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".txt");
            }
        })) {
            this.metinIsle(dosya.getAbsolutePath());
        }
    }

    public void sonlandir() {
        this.istatistikler.sonlandir();
        BinaryIstatistikYazici y = new BinaryIstatistikYazici();
        y.initialize("kaynaklar/tr/bilgi/kok_istatistik_tr.bin");
        y.yaz(this.istatistikler);
        this.istatistikler.setLimit(5000, 5000, 20000);
        DosyaRaporlayici dr = new DosyaRaporlayici(this.istatistikler, "istatistik.txt");
        dr.raporla();
    }

    public Istatistikler getIstatistikler() {
        return this.istatistikler;
    }

    public static void main(String[] args) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> c = Class.forName("net.zemberek.tr.yapi.TurkiyeTurkcesi");
        TurkceDilBilgisi turkce = new TurkceDilBilgisi((DilAyarlari)c.newInstance());
        Zemberek zemberek = new Zemberek((DilAyarlari)c.newInstance());
        IstatistikToplayici top = new IstatistikToplayici(zemberek.cozumleyici(), new Istatistikler(turkce));
        TimeTracker.startClock("i");
        top.metinIsle("text/mail_text.txt");
        top.sonlandir();
        System.out.println("Saniyede islenen ortalama kelime sayisi: " + TimeTracker.getItemsPerSecond("i", top.toplamKelime));
        System.out.println("Toplam sure: " + TimeTracker.stopClock("i"));
    }
}

