/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.istatistik;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.zemberek.araclar.IstatistikAraclari;
import net.zemberek.istatistik.Hece;
import net.zemberek.istatistik.Istatistik;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeceIstatistikleri
implements Istatistik {
    public static final int MAX_HECE = 5000;
    public static final int MAX_HECE_GOSTERIM = 3000;
    private HashMap<String, Hece> heceMap = new HashMap(100);
    private ArrayList<Hece> heceListesi = new ArrayList(100);
    private long heceSayisi = 0L;
    private long toplamHeceBoyu = 0L;

    public void guncelle(String gelenHece) {
        ++this.heceSayisi;
        this.toplamHeceBoyu += (long)gelenHece.length();
        Hece hece = this.heceMap.get(gelenHece);
        if (hece == null) {
            if (this.heceMap.size() < 5000) {
                this.heceMap.put(gelenHece, new Hece(gelenHece));
            }
        } else {
            hece.arttir();
        }
    }

    @Override
    public void tamamla() {
        this.heceListesi.addAll(this.heceMap.values());
        Collections.sort(this.heceListesi);
    }

    public long getHeceSayisi() {
        return this.heceSayisi;
    }

    public List<Hece> getHeceListesi() {
        return this.heceListesi;
    }

    public String toString() {
        String str = "";
        long araToplam = 0L;
        for (int i = 0; i < this.heceListesi.size(); ++i) {
            Hece hece = this.heceListesi.get(i);
            str = str + i + ". " + hece.getHece() + " [" + hece.getKullanim() + "] Oran(%): " + IstatistikAraclari.yuzdeHesaplaStr(hece.getKullanim(), this.heceSayisi) + " AraToplam(%): " + IstatistikAraclari.yuzdeHesaplaStr(araToplam += hece.getKullanim(), this.heceSayisi) + "\n";
            if (i <= 3000) continue;
            return str;
        }
        return str;
    }

    public void raporYaz() {
        String str = "";
        long araToplam = 0L;
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File("heceler.txt")), "ISO-8859-9");
            BufferedWriter writer = new BufferedWriter(osw);
            writer.write("Toplam Hece Sayisi:" + this.heceSayisi + "\n");
            writer.write("Toplam Ayrik Hece Sayisi:" + this.heceListesi.size() + "\n");
            for (int i = 0; i < this.heceListesi.size(); ++i) {
                Hece hece = this.heceListesi.get(i);
                str = i + ". " + hece.getHece() + "  Oran: %" + IstatistikAraclari.onbindeHesaplaStr(hece.getKullanim(), this.heceSayisi) + " AraToplam: %" + IstatistikAraclari.onbindeHesaplaStr(araToplam += hece.getKullanim(), this.heceSayisi) + " [" + hece.getKullanim() + "]\n";
                writer.write(str);
            }
            writer.close();
            System.out.println("Rapor Tamam.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void guncelle() {
    }
}

