/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.istatistik;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.zemberek.araclar.IstatistikAraclari;
import net.zemberek.istatistik.EkZinciri;
import net.zemberek.istatistik.KokIstatistikBilgisi;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.ek.Ek;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenelKokIstatistikBilgisi
implements KokIstatistikBilgisi {
    private Kok kok = null;
    private long kullanimSayisi = 1L;
    protected int kullanimFrekansi = 1;
    private int yalinHal = 0;
    private double ortalamaKelimeUzunlugu = 0.0;
    private long toplamUzunluk = 0L;
    private int ortalamaEkSayisi = 0;
    private ArrayList<EkZinciri> ekListesi = null;
    public static final int TABLO_MAX_EK_ZINCIR_BOYU = 12;
    public static final int TABLO_MAX_EK_SAYISI = 15;
    private HashMap<String, EkZinciri> ekZincirleri = new HashMap();
    int[] ekUzunlukSayilari = new int[15];

    public GenelKokIstatistikBilgisi() {
    }

    public GenelKokIstatistikBilgisi(Kok kok) {
        this.kok = kok;
    }

    public void guncelle(Kelime kelime) {
        ++this.kullanimSayisi;
        this.toplamUzunluk += (long)kelime.boy();
        this.ortalamaKelimeUzunlugu = (double)this.toplamUzunluk / (double)this.kullanimSayisi;
        this.ekZincirleriniGuncelle(kelime.ekler());
    }

    public void ekZincirleriniGuncelle(List<Ek> ekler) {
        int ekSayisi = ekler.size();
        if (ekSayisi > 0 && ekSayisi < 15) {
            int n = ekler.size() - 1;
            this.ekUzunlukSayilari[n] = this.ekUzunlukSayilari[n] + 1;
        }
        if (ekSayisi > 0 && ekSayisi <= 12) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < ekler.size(); ++i) {
                builder.append(ekler.get(i).ad());
                if (i >= ekler.size() - 1) continue;
                builder.append('+');
            }
            String ekAnahtari = builder.toString();
            EkZinciri zincir = this.ekZincirleri.get(ekAnahtari);
            if (zincir == null) {
                zincir = new EkZinciri(ekler);
                this.ekZincirleri.put(ekAnahtari, zincir);
            }
            ++zincir.kullanimSayisi;
        }
    }

    public String toString() {
        String res = "Kulllanim Frekansi : " + this.kullanimSayisi + "Yalin Kullanim :" + this.yalinHal;
        return res;
    }

    public HashMap<String, EkZinciri> getEkZincirleri() {
        return this.ekZincirleri;
    }

    public long getKullanimSayisi() {
        return this.kullanimSayisi;
    }

    public int getOrtalamaEkSayisi() {
        return this.ortalamaEkSayisi;
    }

    public double getOrtalamaKelimeUzunlugu() {
        return this.ortalamaKelimeUzunlugu;
    }

    public int getYalinHal() {
        return this.yalinHal;
    }

    public void duzenle() {
        if (this.ekListesi == null) {
            this.ekListesi = new ArrayList();
        }
        this.ekListesi.clear();
        for (EkZinciri zincir : this.ekZincirleri.values()) {
            zincir.kullanimFrekansi = IstatistikAraclari.yuzdeHesapla(zincir.getKullanimSayisi(), this.kullanimSayisi);
            this.ekListesi.add(zincir);
        }
        Collections.sort(this.ekListesi);
    }

    public List<EkZinciri> getEkListesi() {
        return this.ekListesi;
    }

    public Kok getKok() {
        return this.kok;
    }

    public int[] getEkUzunlukSayilari() {
        return this.ekUzunlukSayilari;
    }

    @Override
    public int getKullanimFrekansi() {
        return this.kullanimFrekansi;
    }

    public void setKullanimFrekansi(int kullanimFrekansi) {
        this.kullanimFrekansi = kullanimFrekansi;
    }

    public void ekZinciriEkle(EkZinciri zincir) {
        this.ekZincirleri.put(zincir.getEklerStr(), zincir);
    }

    public EkZinciri getEkZinciri(String ekZinciriStr) {
        return this.ekZincirleri.get(ekZinciriStr);
    }
}

