/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.istatistik;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.zemberek.araclar.IstatistikAraclari;
import net.zemberek.istatistik.EkFrekansBilgisi;
import net.zemberek.yapi.ek.Ek;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EkIstatistikBilgisi {
    public static long toplamKullanim = 0L;
    private Ek ek;
    private int kullanimSayisi = 0;
    private HashMap<String, EkFrekansBilgisi> ardisilEkler = new HashMap();
    List<EkFrekansBilgisi> ardisilEkListesi = new ArrayList<EkFrekansBilgisi>();

    public EkIstatistikBilgisi(Ek ek) {
        this.ek = ek;
    }

    public void ardisilEkEkle(Ek ardisilEk) {
        EkFrekansBilgisi ekFrek = this.ardisilEkler.get(ardisilEk.ad());
        if (ekFrek == null) {
            ekFrek = new EkFrekansBilgisi(ardisilEk);
            if (ardisilEk.ad() == null) {
                System.out.println("null?");
            }
            this.ardisilEkler.put(ardisilEk.ad(), ekFrek);
        } else {
            ekFrek.kullanimArttir();
        }
        ++this.kullanimSayisi;
        ++toplamKullanim;
    }

    public void duzenle() {
        this.ardisilEkListesi = new ArrayList<EkFrekansBilgisi>();
        for (EkFrekansBilgisi ekFreq : this.ardisilEkler.values()) {
            ekFreq.setKullanimFrekansi(IstatistikAraclari.yuzdeHesapla(ekFreq.getKullanim(), this.kullanimSayisi));
            this.ardisilEkListesi.add(ekFreq);
        }
        Collections.sort(this.ardisilEkListesi);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.ek.ad() + " Kullanim : %" + IstatistikAraclari.onbindeHesaplaStr(this.kullanimSayisi, toplamKullanim) + "\n");
        for (EkFrekansBilgisi freq : this.ardisilEkListesi) {
            buffer.append("  " + freq.getEk().ad());
            buffer.append("  %" + IstatistikAraclari.onbindeHesaplaStr(freq.getKullanim(), this.kullanimSayisi));
            buffer.append("  (" + freq.getKullanim() + ")\n");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public List<EkFrekansBilgisi> getArdisilEkListesi() {
        return this.ardisilEkListesi;
    }
}

