/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.istatistik;

import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import net.zemberek.istatistik.GenelKokIstatistikBilgisi;
import net.zemberek.istatistik.IstatistikYazici;
import net.zemberek.istatistik.Istatistikler;
import net.zemberek.istatistik.KokIstatistikleri;
import net.zemberek.istatistik.TemelIstatistikYazici;
import net.zemberek.yapi.Kok;

public class BinaryIstatistikYazici
extends TemelIstatistikYazici
implements IstatistikYazici {
    public static final int ISTATISTIGI_TUTLACAK_KOK_SAYISI = 20000;
    DataOutputStream dos;

    public void initialize(String fileName) {
        try {
            this.outputFile = new FileOutputStream(fileName);
            this.dos = new DataOutputStream(this.outputFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void yaz(Istatistikler ist) {
        KokIstatistikleri kokIst = ist.getKokIstatistikleri();
        List<GenelKokIstatistikBilgisi> list = kokIst.getKokListesi();
        try {
            int sinir = 20000;
            if (list.size() < 20000) {
                sinir = list.size();
            }
            for (int i = 0; i < sinir; ++i) {
                GenelKokIstatistikBilgisi bilgi = list.get(i);
                Kok kok = bilgi.getKok();
                if (kok == null) {
                    System.out.println("Kok null?? " + i);
                    break;
                }
                this.dos.writeUTF(kok.icerik());
                System.out.println("Kok:" + kok.icerik() + ", indeks:" + kok.getIndeks() + ", Frekans: " + bilgi.getKullanimFrekansi());
                this.dos.writeInt(bilgi.getKullanimFrekansi());
            }
            System.out.println("Istatistigi yazilan kok sayisi: " + sinir);
            this.dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

