/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.islemler.cozumleme;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.zemberek.bilgi.kokler.KokAdayiBulucu;
import net.zemberek.islemler.cozumleme.BasitKelimeYigini;
import net.zemberek.islemler.cozumleme.CozumlemeSeviyesi;
import net.zemberek.islemler.cozumleme.CozumlemeYardimcisi;
import net.zemberek.islemler.cozumleme.HarfDizisiKiyaslayici;
import net.zemberek.islemler.cozumleme.KelimeCozumleyici;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.TurkceHarf;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.ek.EkYonetici;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandartCozumleyici
implements KelimeCozumleyici {
    public static final Kelime[] BOS_KELIME_DIZISI = new Kelime[0];
    private static Logger log = Logger.getLogger(StandartCozumleyici.class.getName());
    private final KokAdayiBulucu kokBulucu;
    private final HarfDizisiKiyaslayici harfDizisiKiyaslayici;
    private EkYonetici ekYonetici;
    private Alfabe alfabe;
    private CozumlemeYardimcisi yardimci;

    public StandartCozumleyici(KokAdayiBulucu kokBulucu, HarfDizisiKiyaslayici kiyaslayci, Alfabe alfabe, EkYonetici ekYonetici, CozumlemeYardimcisi yardimci) {
        this.kokBulucu = kokBulucu;
        this.harfDizisiKiyaslayici = kiyaslayci;
        this.ekYonetici = ekYonetici;
        this.alfabe = alfabe;
        this.yardimci = yardimci;
    }

    @Override
    public Kelime[] cozumle(String strGiris, CozumlemeSeviyesi seviye) {
        String strIslenmis = this.alfabe.ayikla(strGiris);
        if (!this.alfabe.cozumlemeyeUygunMu(strIslenmis) || strIslenmis.length() == 0) {
            return BOS_KELIME_DIZISI;
        }
        List<Kok> kokler = this.kokBulucu.adayKokleriBul(strIslenmis);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Giris: " + strGiris + ", Adaylar: " + kokler);
        }
        HarfDizisi girisDizi = new HarfDizisi(strIslenmis, this.alfabe);
        boolean icerikDegisti = false;
        ArrayList<Kelime> cozumler = new ArrayList<Kelime>(2);
        for (int i = kokler.size() - 1; i >= 0; --i) {
            HarfDizisi kokDizi;
            if (icerikDegisti) {
                girisDizi = new HarfDizisi(strIslenmis, this.alfabe);
                icerikDegisti = false;
            }
            Kok kok = kokler.get(i);
            if (log.isLoggable(Level.FINER)) {
                log.finest("Aday:" + kok.icerik());
            }
            if (this.harfDizisiKiyaslayici.kiyasla(kokDizi = new HarfDizisi(kok.icerik(), this.alfabe), girisDizi)) {
                Kelime kelime = this.kelimeUret(kok, kokDizi);
                if (!this.yardimci.kelimeBicimiDenetle(kelime, strGiris)) continue;
                if (seviye == CozumlemeSeviyesi.TEK_KOK) {
                    return new Kelime[]{kelime};
                }
                cozumler.add(kelime);
                continue;
            }
            icerikDegisti = this.yardimci.kokGirisDegismiVarsaUygula(kok, kokDizi, girisDizi);
            List<Kelime> sonuclar = this.coz(kok, kokDizi, girisDizi, seviye);
            for (Kelime sonuc : sonuclar) {
                if (!this.yardimci.kelimeBicimiDenetle(sonuc, strGiris)) continue;
                if (seviye == CozumlemeSeviyesi.TEK_KOK) {
                    return new Kelime[]{sonuc};
                }
                cozumler.add(sonuc);
            }
        }
        return cozumler.toArray(new Kelime[cozumler.size()]);
    }

    @Override
    public boolean cozumlenebilir(String giris) {
        return this.cozumle(giris, CozumlemeSeviyesi.TEK_KOK).length == 1;
    }

    private Kelime kelimeUret(Kok kok, HarfDizisi dizi) {
        Kelime kelime = new Kelime(kok, dizi);
        kelime.ekEkle(this.ekYonetici.ilkEkBelirle(kelime.kok()));
        return kelime;
    }

    private List<Kelime> coz(Kok kok, HarfDizisi kokDizi, HarfDizisi giris, CozumlemeSeviyesi seviye) {
        Kelime kelime = this.kelimeUret(kok, kokDizi);
        BasitKelimeYigini kelimeYigini = new BasitKelimeYigini();
        Ek bulunanEk = kelime.sonEk();
        int ardisilEkSirasi = 0;
        List<Kelime> uygunSonuclar = Collections.emptyList();
        TurkceHarf ilkEkHarfi = giris.harf(kelime.boy());
        while (true) {
            HarfDizisi olusanEkIcerigi;
            Ek incelenenEk;
            if ((incelenenEk = bulunanEk.getArdisilEk(ardisilEkSirasi++)) == null) {
                if (kelimeYigini.bosMu()) {
                    return uygunSonuclar;
                }
                BasitKelimeYigini.YiginKelime yiginKelime = kelimeYigini.al();
                kelime = yiginKelime.getKelime();
                bulunanEk = kelime.sonEk();
                ardisilEkSirasi = yiginKelime.getEkSirasi();
                ilkEkHarfi = giris.harf(kelime.boy());
                continue;
            }
            if (kelime.gercekEkYok() && kelime.kok().ozelDurumVarmi()) {
                if (!this.ozelDurumUygula(kelime, giris, incelenenEk)) continue;
                ilkEkHarfi = giris.harf(kelime.boy());
            }
            if (!incelenenEk.ilkHarfDenetle(ilkEkHarfi) || (olusanEkIcerigi = incelenenEk.cozumlemeIcinUret(kelime, giris, this.harfDizisiKiyaslayici)) == null || olusanEkIcerigi.length() == 0 || !this.harfDizisiKiyaslayici.aradanKiyasla(giris, olusanEkIcerigi, kelime.boy())) continue;
            kelimeYigini.koy(kelime.clone(), ardisilEkSirasi);
            ardisilEkSirasi = 0;
            kelime.ekEkle(incelenenEk);
            kelime.icerikEkle(olusanEkIcerigi);
            ilkEkHarfi = giris.harf(kelime.boy());
            if (log.isLoggable(Level.FINE)) {
                log.fine("ekleme sonrasi olusan kelime: " + kelime.icerik());
            }
            bulunanEk = incelenenEk;
            if (!this.harfDizisiKiyaslayici.kiyasla(kelime.icerik(), giris) || incelenenEk.sonEkOlamazMi()) continue;
            if (seviye != CozumlemeSeviyesi.TUM_KOK_VE_EKLER) {
                uygunSonuclar = new ArrayList<Kelime>(1);
                uygunSonuclar.add(kelime);
                return uygunSonuclar;
            }
            if (uygunSonuclar.isEmpty()) {
                uygunSonuclar = new ArrayList<Kelime>(2);
            }
            uygunSonuclar.add(kelime.clone());
        }
    }

    private boolean ozelDurumUygula(Kelime kelime, HarfDizisi giris, Ek ek) {
        if (!kelime.kok().yapiBozucuOzelDurumVarmi()) {
            return true;
        }
        HarfDizisi testKokIcerigi = kelime.kok().ozelDurumUygula(this.alfabe, ek);
        if (testKokIcerigi == null) {
            return false;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Ozel durum sonrasi:" + testKokIcerigi + "  ek:" + ek.ad());
        }
        kelime.setIcerik(testKokIcerigi);
        return this.harfDizisiKiyaslayici.bastanKiyasla(giris, testKokIcerigi);
    }
}

