/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.islemler;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.zemberek.araclar.turkce.YaziBirimi;
import net.zemberek.araclar.turkce.YaziBirimiTipi;
import net.zemberek.araclar.turkce.YaziIsleyici;
import net.zemberek.islemler.cozumleme.KelimeCozumleyici;

public class TurkceYaziTesti {
    private static Logger log = Logger.getLogger("TurkceYaziTesti.class");
    KelimeCozumleyici cozumleyici;
    KelimeCozumleyici asciiCozumleyici;
    public static final int HIC = 0;
    public static final int AZ = 1;
    public static final int ORTA = 2;
    public static final int YUKSEK = 3;
    public static final int KESIN = 4;

    public TurkceYaziTesti(KelimeCozumleyici cozumleyici, KelimeCozumleyici asciiCozumleyici) {
        this.cozumleyici = cozumleyici;
        this.asciiCozumleyici = asciiCozumleyici;
    }

    private double turkceOranla(String yazi) {
        int cozulenler = 0;
        int asciiCozulenler = 0;
        int cozulemeyenler = 0;
        List<YaziBirimi> analizDizisi = YaziIsleyici.analizDizisiOlustur(yazi);
        for (int i = 0; i < analizDizisi.size(); ++i) {
            YaziBirimi birim = analizDizisi.get(i);
            if (birim.tip != YaziBirimiTipi.KELIME) continue;
            if (this.cozumleyici.cozumlenebilir(birim.icerik)) {
                ++cozulenler;
                continue;
            }
            if (this.asciiCozumleyici.cozumlenebilir(birim.icerik)) {
                ++asciiCozulenler;
                continue;
            }
            ++cozulemeyenler;
        }
        int toplam = cozulenler + asciiCozulenler;
        if (toplam == 0 || toplam + cozulemeyenler == 0) {
            return 0.0;
        }
        if (cozulemeyenler == 0) {
            return 1.0;
        }
        double sonuc = 1.0 - (double)cozulemeyenler / (double)(toplam + cozulemeyenler);
        if (log.isLoggable(Level.FINER)) {
            log.finer("cozulenler:" + cozulenler + "  ascii Cozulenler:" + asciiCozulenler + "cozulemeyenler:" + cozulemeyenler + "  oran:" + sonuc);
        }
        return sonuc;
    }

    public int turkceTest(String giris) {
        double sonuc = this.turkceOranla(giris);
        if (sonuc <= 0.1) {
            return 0;
        }
        if (sonuc > 0.1 && sonuc <= 0.35) {
            return 1;
        }
        if (sonuc > 0.35 && sonuc <= 0.65) {
            return 2;
        }
        if (sonuc > 0.65 && sonuc <= 0.95) {
            return 3;
        }
        return 4;
    }
}

