/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.islemler;

import java.util.ArrayList;
import java.util.List;
import net.zemberek.islemler.cozumleme.CozumlemeYardimcisi;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.EkSiralayici;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.ek.EkYonetici;
import net.zemberek.yapi.ek.TemelEkYonetici;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KelimeUretici {
    private final Alfabe alfabe;
    private final CozumlemeYardimcisi yardimci;
    private final EkYonetici ekYonetici;

    public KelimeUretici(Alfabe alfabe, EkYonetici ekler, CozumlemeYardimcisi yardimci) {
        this.ekYonetici = ekler;
        this.alfabe = alfabe;
        this.yardimci = yardimci;
    }

    public String kelimeUret(Kok kok, List<Ek> ekler) {
        UretimNesnesi ure = this.uretimNesnesiUret(kok, ekler);
        return ure.olusum;
    }

    String sirasizEklerleUret(Kok kok, List<Ek> ekler) {
        List<List<Ek>> sonuclar;
        Ek ilkEk = this.ekYonetici.ilkEkBelirle(kok);
        if (ilkEk == TemelEkYonetici.BOS_EK) {
            return kok.icerik();
        }
        if (ekler.contains(ilkEk)) {
            ekler.remove(ilkEk);
        }
        if ((sonuclar = new EkSiralayici(ekler, ilkEk).olasiEkDizilimleriniBul()).isEmpty()) {
            return kok.icerik();
        }
        return this.uretimNesnesiUret((Kok)kok, sonuclar.get((int)0)).olusum;
    }

    public String[] ayristir(Kelime kelime) {
        UretimNesnesi ure = this.uretimNesnesiUret(kelime.kok(), kelime.ekler());
        return ure.olusumlar.toArray(new String[ure.olusumlar.size()]);
    }

    private UretimNesnesi uretimNesnesiUret(Kok kok, List<Ek> ekler) {
        HarfDizisi ozelDurumSonrasi;
        if (kok == null) {
            return new UretimNesnesi("");
        }
        UretimNesnesi ure = new UretimNesnesi(kok.icerik());
        Kelime kelime = new Kelime(kok, this.alfabe);
        if (ekler.size() > 1) {
            ozelDurumSonrasi = kok.ozelDurumUygula(this.alfabe, ekler.get(1));
            if (ozelDurumSonrasi == null) {
                return this.sonucBicimlendir(ure, kelime);
            }
        } else {
            return this.sonucBicimlendir(ure, kelime);
        }
        kelime.setIcerik(ozelDurumSonrasi);
        this.yardimci.kokGirisDegismiVarsaUygula(kok, kelime.icerik(), null);
        for (int i = 0; i < ekler.size(); ++i) {
            Ek oncekiEk;
            Ek ek = ekler.get(i);
            if (i > 0 && !(oncekiEk = ekler.get(i - 1)).ardindanGelebilirMi(ek)) {
                return ure;
            }
            HarfDizisi ekOlusumu = i < ekler.size() - 1 ? new HarfDizisi(ek.olusumIcinUret(kelime, ekler.get(i + 1))) : new HarfDizisi(ek.olusumIcinUret(kelime, TemelEkYonetici.BOS_EK));
            kelime.icerikEkle(ekOlusumu);
            if (ekOlusumu.length() > 0) {
                ure.olusumlar.add(ekOlusumu.toString());
            }
            kelime.ekEkle(ek);
        }
        return this.sonucBicimlendir(ure, kelime);
    }

    private UretimNesnesi sonucBicimlendir(UretimNesnesi ure, Kelime kelime) {
        this.yardimci.kelimeBicimlendir(kelime);
        ure.olusum = kelime.icerikStr();
        return ure;
    }

    class UretimNesnesi {
        String olusum = "";
        List<String> olusumlar = new ArrayList<String>(4);

        public UretimNesnesi(String ilkolusum) {
            this.olusum = ilkolusum;
            this.olusumlar.add(ilkolusum);
        }
    }
}

