/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.islemler;

import java.util.ArrayList;
import java.util.Arrays;
import net.zemberek.islemler.KelimeKokFrekansKiyaslayici;
import net.zemberek.islemler.KokBulucu;
import net.zemberek.islemler.cozumleme.CozumlemeSeviyesi;
import net.zemberek.islemler.cozumleme.KelimeCozumleyici;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.Kok;

public class KelimeTabanliKokBulucu
implements KokBulucu {
    KelimeCozumleyici cozumleyici;
    Alfabe alfabe;

    public KelimeTabanliKokBulucu(KelimeCozumleyici cozumleyici, Alfabe alfabe) {
        this.cozumleyici = cozumleyici;
        this.alfabe = alfabe;
    }

    public Kok[] kokBul(String giris) {
        Kelime[] cozumler = this.cozumleVeSirala(giris);
        ArrayList<Kok> sonuclar = new ArrayList<Kok>(cozumler.length);
        for (Kelime kelime : cozumler) {
            if (sonuclar.contains(kelime.kok())) continue;
            sonuclar.add(kelime.kok());
        }
        return sonuclar.toArray(new Kok[sonuclar.size()]);
    }

    private Kelime[] cozumleVeSirala(String giris) {
        Kelime[] cozumler = this.cozumleyici.cozumle(giris, CozumlemeSeviyesi.TUM_KOKLER);
        Arrays.sort(cozumler, new KelimeKokFrekansKiyaslayici());
        return cozumler;
    }

    public String[] stringKokBul(String giris) {
        Kelime[] cozumler = this.cozumleVeSirala(giris);
        ArrayList<String> sonuclar = new ArrayList<String>(cozumler.length);
        for (Kelime kelime : cozumler) {
            String s = kelime.kok().asilIcerikUret(this.alfabe);
            if (sonuclar.contains(s)) continue;
            sonuclar.add(s);
        }
        return sonuclar.toArray(new String[sonuclar.size()]);
    }
}

