/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.islemler;

import java.util.List;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.Heceleyici;

public class HeceIslemleri {
    private final Alfabe alfabe;
    private final Heceleyici heceleyici;

    public HeceIslemleri(Alfabe alfabe, Heceleyici heceleyici) {
        this.alfabe = alfabe;
        this.heceleyici = heceleyici;
    }

    public String[] hecele(String giris) {
        List<String> l = this.heceleyici.hecele(new HarfDizisi(giris, this.alfabe));
        return l.toArray(new String[l.size()]);
    }

    public boolean hecelenebilirmi(String giris) {
        return this.heceleyici.hecele(new HarfDizisi(giris, this.alfabe)).size() != 0;
    }

    public int[] heceIndeksleriniBul(String giris) {
        giris = this.alfabe.ayikla(giris);
        String[] heceler = this.hecele(giris);
        int[] heceIndexleri = new int[heceler.length];
        if (heceler.length == 0) {
            return null;
        }
        int i = 0;
        int sayac = 0;
        heceIndexleri[i++] = 0;
        for (String hece : heceler) {
            if (i == heceler.length) break;
            heceIndexleri[i++] = sayac += hece.length();
        }
        return heceIndexleri;
    }
}

