/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.erisim;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.zemberek.araclar.Kayitci;
import net.zemberek.bilgi.KaynakYukleyici;
import net.zemberek.bilgi.ZemberekAyarlari;
import net.zemberek.bilgi.kokler.KokAdayiBulucu;
import net.zemberek.bilgi.kokler.Sozluk;
import net.zemberek.islemler.AsciiDonusturucu;
import net.zemberek.islemler.DenetlemeCebi;
import net.zemberek.islemler.HeceIslemleri;
import net.zemberek.islemler.KelimeKokFrekansKiyaslayici;
import net.zemberek.islemler.KelimeTabanliKokBulucu;
import net.zemberek.islemler.KelimeUretici;
import net.zemberek.islemler.KokBulucu;
import net.zemberek.islemler.TurkceYaziTesti;
import net.zemberek.islemler.cozumleme.AsciiToleransliHDKiyaslayici;
import net.zemberek.islemler.cozumleme.CozumlemeSeviyesi;
import net.zemberek.islemler.cozumleme.KelimeCozumleyici;
import net.zemberek.islemler.cozumleme.KesinHDKiyaslayici;
import net.zemberek.islemler.cozumleme.OneriUretici;
import net.zemberek.islemler.cozumleme.StandartCozumleyici;
import net.zemberek.islemler.cozumleme.ToleransliCozumleyici;
import net.zemberek.yapi.DilAyarlari;
import net.zemberek.yapi.DilBilgisi;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.TurkceDilBilgisi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zemberek {
    static Logger log = Kayitci.kayitciUret(Zemberek.class);
    private KelimeCozumleyici cozumleyici;
    private KelimeUretici kelimeUretici;
    private KelimeCozumleyici asciiToleransliCozumleyici;
    private TurkceYaziTesti turkceTest;
    private OneriUretici oneriUretici;
    private AsciiDonusturucu asciiDonusturucu;
    private HeceIslemleri heceIslemleri;
    private ZemberekAyarlari ayarlar;
    private DilBilgisi dilBilgisi;
    private DenetlemeCebi denetlemeCebi;

    public Zemberek(DilAyarlari dilayarlari) {
        this.ayarlar = new ZemberekAyarlari(dilayarlari.locale().getLanguage());
        this.dilBilgisi = new TurkceDilBilgisi(dilayarlari, this.ayarlar);
        this.initialize();
    }

    public static ZemberekAyarlari ayarOlustur(String disKonfigurasyon) throws IOException {
        URI uri = new File(disKonfigurasyon).toURI();
        Properties props = new KaynakYukleyici().konfigurasyonYukle(uri);
        return new ZemberekAyarlari(props);
    }

    private void initialize() {
        Sozluk kokler = this.dilBilgisi.kokler();
        KokAdayiBulucu kokBulucu = kokler.kokBulucuFactory().kesinKokBulucu();
        this.cozumleyici = new StandartCozumleyici(kokBulucu, new KesinHDKiyaslayici(), this.dilBilgisi.alfabe(), this.dilBilgisi.ekler(), this.dilBilgisi.cozumlemeYardimcisi());
        KokAdayiBulucu turkceToleransliKokBulucu = kokler.kokBulucuFactory().asciiKokBulucu();
        this.asciiToleransliCozumleyici = new StandartCozumleyici(turkceToleransliKokBulucu, new AsciiToleransliHDKiyaslayici(), this.dilBilgisi.alfabe(), this.dilBilgisi.ekler(), this.dilBilgisi.cozumlemeYardimcisi());
        KokAdayiBulucu toleransliBulucu = kokler.kokBulucuFactory().toleransliKokBulucu(1);
        ToleransliCozumleyici toleransliCozumleyici = new ToleransliCozumleyici(toleransliBulucu, this.dilBilgisi.ekler(), this.dilBilgisi.alfabe(), this.dilBilgisi.cozumlemeYardimcisi());
        this.oneriUretici = new OneriUretici(this.dilBilgisi.cozumlemeYardimcisi(), this.cozumleyici, this.asciiToleransliCozumleyici, toleransliCozumleyici, this.ayarlar);
        this.turkceTest = new TurkceYaziTesti(this.cozumleyici, this.asciiToleransliCozumleyici);
        this.asciiDonusturucu = new AsciiDonusturucu(this.dilBilgisi.alfabe());
        this.heceIslemleri = new HeceIslemleri(this.dilBilgisi.alfabe(), this.dilBilgisi.heceBulucu());
        this.kelimeUretici = new KelimeUretici(this.dilBilgisi.alfabe(), this.dilBilgisi.ekler(), this.dilBilgisi.cozumlemeYardimcisi());
        this.denetlemeCebi = this.dilBilgisi.denetlemeCebi();
    }

    public KelimeCozumleyici cozumleyici() {
        return this.cozumleyici;
    }

    public KelimeUretici kelimeUretici() {
        return this.kelimeUretici;
    }

    public KelimeCozumleyici asciiToleransliCozumleyici() {
        return this.asciiToleransliCozumleyici;
    }

    public OneriUretici oneriUretici() {
        return this.oneriUretici;
    }

    public HeceIslemleri heceleyici() {
        return this.heceIslemleri;
    }

    public boolean kelimeDenetle(String giris) {
        if (this.denetlemeCebi != null) {
            return this.denetlemeCebi.kontrol(giris) || this.cozumleyici.cozumlenebilir(giris);
        }
        return this.cozumleyici.cozumlenebilir(giris);
    }

    public Kelime[] kelimeCozumle(String giris) {
        return this.cozumleyici.cozumle(giris, CozumlemeSeviyesi.TUM_KOK_VE_EKLER);
    }

    public Kelime[] kelimeCozumle(String giris, CozumlemeSeviyesi strateji) {
        return this.cozumleyici.cozumle(giris, strateji);
    }

    public Kelime[] asciiCozumle(String giris) {
        Kelime[] sonuclar = this.asciiToleransliCozumleyici.cozumle(giris, CozumlemeSeviyesi.TUM_KOK_VE_EKLER);
        Arrays.sort(sonuclar, new KelimeKokFrekansKiyaslayici());
        return sonuclar;
    }

    public Kelime[] asciiCozumle(String giris, CozumlemeSeviyesi seviye) {
        Kelime[] sonuclar = this.asciiToleransliCozumleyici.cozumle(giris, seviye);
        Arrays.sort(sonuclar, new KelimeKokFrekansKiyaslayici());
        return sonuclar;
    }

    public String[] asciidenTurkceye(String giris) {
        Kelime[] kelimeler = this.asciiCozumle(giris, CozumlemeSeviyesi.TUM_KOKLER);
        ArrayList<String> olusumlar = new ArrayList<String>(kelimeler.length);
        for (Kelime kelime : kelimeler) {
            String olusum = kelime.icerikStr();
            if (olusumlar.contains(olusum)) continue;
            olusumlar.add(olusum);
        }
        return olusumlar.toArray(new String[olusumlar.size()]);
    }

    public String asciiyeDonustur(String giris) {
        return this.asciiDonusturucu.toAscii(giris);
    }

    public String[] hecele(String giris) {
        return this.heceIslemleri.hecele(giris);
    }

    public String[] oner(String giris) {
        return this.oneriUretici.oner(giris);
    }

    public int dilTesti(String giris) {
        return this.turkceTest.turkceTest(giris);
    }

    public DilBilgisi dilBilgisi() {
        return this.dilBilgisi;
    }

    public String kelimeUret(Kok kok, List ekler) {
        return this.kelimeUretici.kelimeUret(kok, ekler);
    }

    public List<String[]> kelimeAyristir(String kelime) {
        Kelime[] cozumler;
        HashSet<String[]> sonuclar = new HashSet<String[]>();
        for (Kelime kel : cozumler = this.cozumleyici.cozumle(kelime, CozumlemeSeviyesi.TUM_KOK_VE_EKLER)) {
            sonuclar.add(this.kelimeUretici.ayristir(kel));
        }
        return new ArrayList<String[]>(sonuclar);
    }

    public ZemberekAyarlari ayarlar() {
        return this.ayarlar;
    }

    public KokBulucu kokBulucu() {
        return new KelimeTabanliKokBulucu(this.cozumleyici, this.dilBilgisi.alfabe());
    }
}

