/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi.kokler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.zemberek.yapi.Kok;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KokDugumu {
    private AltDugumListesi altDugumler = null;
    private char harf;
    private List<Kok> esSesliler = null;
    private Kok kok = null;
    private CharSequence kelime = null;
    private static final int CEP_BUYUKLUGU = 3;

    public KokDugumu() {
    }

    public KokDugumu(char harf) {
        this.harf = harf;
    }

    public KokDugumu(char harf, CharSequence icerik, Kok kok) {
        this.harf = harf;
        this.kok = kok;
        if (!icerik.equals(kok.icerik())) {
            this.kelime = icerik;
        }
    }

    public final KokDugumu altDugumBul(char in) {
        if (this.altDugumler == null) {
            return null;
        }
        return this.altDugumler.altDugum(in);
    }

    public final KokDugumu dugumEkle(KokDugumu dugum) {
        if (this.altDugumler == null) {
            this.altDugumler = new AltDugumListesi();
        }
        this.altDugumler.ekle(dugum);
        return dugum;
    }

    public final KokDugumu[] altDugumDizisi() {
        if (this.altDugumler == null) {
            return new KokDugumu[0];
        }
        return this.altDugumler.altDugumlerDizisi();
    }

    public final boolean altDugumVarMi() {
        return this.altDugumler != null && this.altDugumler.size() != 0;
    }

    public final void kokEkle(Kok kok) {
        if (this.kok != null) {
            if (this.esSesliler == null) {
                this.esSesliler = new ArrayList<Kok>(1);
            }
            this.esSesliler.add(kok);
        } else {
            this.kok = kok;
        }
    }

    public final Kok kok() {
        return this.kok;
    }

    public final List<Kok> esSesliler() {
        return this.esSesliler;
    }

    public final CharSequence kelime() {
        if (this.kelime != null) {
            return this.kelime;
        }
        if (this.kok != null) {
            return this.kok.icerik();
        }
        return null;
    }

    public final void setKelime(CharSequence kelime) {
        this.kelime = kelime;
    }

    public List<Kok> tumKokler() {
        if (this.kok != null) {
            ArrayList<Kok> kokler = new ArrayList<Kok>();
            kokler.add(this.kok);
            if (this.esSesliler != null) {
                kokler.addAll(this.esSesliler);
            }
            return kokler;
        }
        return null;
    }

    public List<Kok> tumKokler(String icerik) {
        if (this.kok != null) {
            ArrayList<Kok> kokler = new ArrayList<Kok>(2);
            kokler.add(this.kok);
            if (this.esSesliler != null) {
                kokler.addAll(this.esSesliler);
            }
            return kokler;
        }
        return null;
    }

    public final void tumKokleriEkle(List<Kok> kokler) {
        if (this.kok != null && !kokler.contains(this.kok)) {
            kokler.add(this.kok);
            if (this.esSesliler != null) {
                kokler.addAll(this.esSesliler);
            }
        }
    }

    public final void temizle() {
        this.kok = null;
        this.kelime = null;
        this.esSesliler = null;
    }

    public final void kopyala(KokDugumu kaynak) {
        this.kok = kaynak.kok();
        this.kelime = kaynak.kelime();
        this.esSesliler = kaynak.esSesliler();
    }

    public final char harf() {
        return this.harf;
    }

    public final void setHarf(char harf) {
        this.harf = harf;
    }

    public final String goster(int level) {
        KokDugumu[] subNodes;
        char[] indentChars = new char[level * 2];
        for (int i = 0; i < indentChars.length; ++i) {
            indentChars[i] = 32;
        }
        String indent = new String(indentChars);
        String str = indent + " Harf: " + this.harf;
        if (this.kelime != null) {
            str = str + " [Kelime: " + this.kelime + "] ";
        }
        if (this.kok != null) {
            str = str + " [Kok: " + this.kok + "] ";
        }
        if (this.esSesliler != null) {
            str = str + " [Es sesli: ";
            for (Kok anEsSesliler : this.esSesliler) {
                str = str + anEsSesliler + " ";
            }
            str = str + " ]";
        }
        if ((subNodes = this.altDugumDizisi()) != null) {
            str = str + "\n " + indent + " Alt dugumler:\n";
            for (KokDugumu subNode : subNodes) {
                if (subNode == null) continue;
                str = str + subNode.goster(level + 1) + "\n";
            }
        }
        return str;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("harf:").append(this.harf);
        if (this.altDugumler != null) {
            buf.append(" alt dugum sayisi:").append(this.altDugumler.size());
        }
        return buf.toString();
    }

    private final class AltDugumListesi {
        KokDugumu[] dugumler = new KokDugumu[3];
        int index = 0;
        HashMap<Character, KokDugumu> tumDugumler = null;

        private AltDugumListesi() {
        }

        public final void ekle(KokDugumu dugum) {
            if (this.index == 3) {
                if (this.tumDugumler == null) {
                    this.tumDugumler = new HashMap(5);
                    for (int i = 0; i < 3; ++i) {
                        this.tumDugumler.put(Character.valueOf(this.dugumler[i].harf()), this.dugumler[i]);
                    }
                    this.dugumler = null;
                }
                this.tumDugumler.put(Character.valueOf(dugum.harf()), dugum);
            } else {
                this.dugumler[this.index++] = dugum;
            }
        }

        public final KokDugumu altDugum(char giris) {
            if (this.dugumler != null) {
                for (int i = 0; i < this.index; ++i) {
                    if (this.dugumler[i].harf() != giris) continue;
                    return this.dugumler[i];
                }
                return null;
            }
            return this.tumDugumler.get(Character.valueOf(giris));
        }

        public final KokDugumu[] altDugumlerDizisi() {
            if (this.dugumler != null) {
                return this.dugumler;
            }
            return this.tumDugumler.values().toArray(new KokDugumu[this.tumDugumler.values().size()]);
        }

        public final int size() {
            if (this.dugumler != null) {
                return this.index;
            }
            return this.tumDugumler.size();
        }
    }
}

