/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi.kokler;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.zemberek.bilgi.kokler.KokAdayiBulucu;
import net.zemberek.bilgi.kokler.KokAgaci;
import net.zemberek.bilgi.kokler.KokDugumu;
import net.zemberek.yapi.Kok;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiKokAdayiBulucu
implements KokAdayiBulucu {
    private static Logger log = Logger.getLogger(AsciiKokAdayiBulucu.class.getName());
    KokAgaci agac = null;
    private int walkCount = 0;
    private String giris;
    private String asciiGiris;
    private List<Kok> adaylar = null;

    public AsciiKokAdayiBulucu(KokAgaci agac) {
        this.agac = agac;
    }

    public int getYurumeSayisi() {
        return this.walkCount;
    }

    @Override
    public List<Kok> adayKokleriBul(String giris) {
        this.giris = giris;
        this.asciiGiris = this.agac.getAlfabe().asciifyString(giris);
        this.adaylar = new ArrayList<Kok>(4);
        this.yuru(this.agac.getKokDugumu(), "");
        return this.adaylar;
    }

    public boolean asciiTolaransliKarsilastir(String aday, String giris) {
        if (aday.length() > giris.length()) {
            return false;
        }
        String clean = this.agac.getAlfabe().asciifyString(aday);
        return this.asciiGiris.startsWith(clean);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void yuru(KokDugumu dugum, String olusan) {
        String tester = (olusan + dugum.harf()).trim();
        ++this.walkCount;
        if (dugum.kok() != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Kok : " + dugum.kelime());
            }
            if (!this.asciiTolaransliKarsilastir((String)dugum.kelime(), this.giris)) return;
            dugum.tumKokleriEkle(this.adaylar);
        } else if (!this.asciiTolaransliKarsilastir(tester, this.giris)) {
            return;
        }
        int seviye = tester.length();
        if (seviye == this.giris.length()) {
            return;
        }
        for (KokDugumu altDugum : dugum.altDugumDizisi()) {
            if (altDugum == null || !this.agac.getAlfabe().asciiToleransliKiyasla(altDugum.harf(), this.giris.charAt(seviye))) continue;
            this.yuru(altDugum, tester);
        }
    }
}

