/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import net.zemberek.araclar.Kayitci;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KaynakYukleyici {
    private static Logger log = Kayitci.kayitciUret(KaynakYukleyici.class);
    private final String encoding;
    private static final byte[] bomBytes = new byte[]{-17, -69, -65};

    public KaynakYukleyici() {
        this.encoding = Charset.defaultCharset().name();
        log.fine("Kaynak yukleyici olusturuluyor. varsayilan karakter seti:" + this.encoding);
    }

    public KaynakYukleyici(String encoding) {
        if (encoding == null) {
            log.warning("encoding null, varsayilan deger kullanilacak.");
            this.encoding = Charset.defaultCharset().name();
        } else {
            this.encoding = encoding.toUpperCase();
        }
        log.fine("Kaynak yukleyici olusturuluyor. varsayilan karakter seti:" + encoding);
    }

    public BufferedReader getReader(String kaynakAdi) throws IOException {
        InputStream is = this.getStream(kaynakAdi);
        if (is == null) {
            throw new IOException(kaynakAdi + " erisimi saglanamadi, Elde edilen Stream degeri null!");
        }
        return new BufferedReader(new InputStreamReader(is, this.encoding));
    }

    public boolean kaynakMevcutmu(String kaynakAdi) {
        if (this.getClass().getResource("/" + kaynakAdi) != null) {
            return true;
        }
        try {
            if (new File(kaynakAdi).exists()) {
                return true;
            }
        }
        catch (SecurityException e) {
            System.out.println("Guvenlik hatasi nedeniyle dis dosya erisimi mumkun degil.");
        }
        return false;
    }

    private InputStream utf8BomDenetle(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("inputStream is null. throwing exception");
        }
        if (this.encoding != null && !this.encoding.equalsIgnoreCase("UTF-8")) {
            return is;
        }
        PushbackInputStream pis = new PushbackInputStream(is, bomBytes.length);
        byte[] okunanBom = new byte[bomBytes.length];
        if (pis.read(okunanBom, 0, bomBytes.length) == -1) {
            return is;
        }
        if (!Arrays.equals(okunanBom, bomBytes)) {
            pis.unread(okunanBom);
        }
        return pis;
    }

    public InputStream getStream(String kaynakAdi) throws IOException {
        InputStream stream;
        try {
            stream = this.utf8BomDenetle(this.getClass().getResourceAsStream("/" + kaynakAdi));
            log.info("classpath kaynak erisimi saglandi:" + kaynakAdi + " kodlama:" + this.encoding);
        }
        catch (IOException e) {
            stream = this.utf8BomDenetle(new FileInputStream(kaynakAdi));
            if (stream == null) {
                throw new IOException("Kaynak erisim hatasi: " + kaynakAdi);
            }
            log.info("Proje ici kaynak erisimi saglandi:" + kaynakAdi + " kodlama:" + this.encoding);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> kodlamaliOzellikDosyasiOku(String dosyaAdi) throws IOException {
        BufferedReader reader = null;
        try {
            reader = this.getReader(dosyaAdi);
            HashMap<String, String> ozellikler = new HashMap<String, String>();
            while (reader.ready()) {
                String line = reader.readLine().trim();
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                int esitlik = line.indexOf(61);
                if (esitlik == -1) {
                    throw new IllegalArgumentException("Ozellik satirinda '=' simgesi bekleniyordu");
                }
                String key = line.substring(0, esitlik).trim();
                if (line.length() > esitlik - 1) {
                    ozellikler.put(key, line.substring(esitlik + 1).trim());
                    continue;
                }
                ozellikler.put(key, "");
            }
            HashMap<String, String> hashMap = ozellikler;
            return hashMap;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public Properties konfigurasyonYukle(URI uri) throws IOException {
        Properties props = new Properties();
        props.load(this.getStream(uri.toURL().getPath()));
        log.info("Dis properties stream erisimi saglandi:" + uri + " kodlama:" + this.encoding);
        return props;
    }

    public Properties konfigurasyonYukle(String dosya) throws IOException {
        Properties props = new Properties();
        props.load(this.getStream(dosya));
        log.info("properties kaynak erisimi saglandi:" + dosya + " kodlama:" + this.encoding);
        return props;
    }
}

