/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.araclar.turkce;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.zemberek.araclar.turkce.YaziBirimi;
import net.zemberek.araclar.turkce.YaziBirimiTipi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YaziIsleyici {
    public static BreakIterator kelimeIt = BreakIterator.getWordInstance(new Locale("tr"));
    public static BreakIterator cumleIt = BreakIterator.getSentenceInstance(new Locale("tr"));

    public static List<String> kelimeAyikla(String target) {
        kelimeIt.setText(target);
        int start = kelimeIt.first();
        int end = kelimeIt.next();
        ArrayList<String> kelimeList = new ArrayList<String>();
        while (end != -1) {
            String word = target.substring(start, end);
            if (Character.isLetterOrDigit(word.charAt(0))) {
                kelimeList.add(word);
            }
            start = end;
            end = kelimeIt.next();
        }
        return kelimeList;
    }

    public static List<String> analizIcinKelimeAyikla(String target) {
        List<String> cumleler = YaziIsleyici.cumleAyikla(target);
        ArrayList<String> tumKelimeler = new ArrayList<String>();
        for (int i = 0; i < cumleler.size(); ++i) {
            String cumle = cumleler.get(i);
            List<String> kelimeler = YaziIsleyici.kelimeAyikla(cumle);
            for (int j = 0; j < kelimeler.size(); ++j) {
                String kelime = kelimeler.get(j);
                if (!Character.isLowerCase(kelime.charAt(0))) continue;
                char[] chrs = kelime.toCharArray();
                boolean nokta = false;
                for (int k = 0; k < chrs.length; ++k) {
                    if (chrs[k] != '.' && chrs[k] != '-') continue;
                    nokta = true;
                }
                if (nokta) continue;
                tumKelimeler.add(kelime);
            }
        }
        return tumKelimeler;
    }

    public static List<String> cumleAyikla(String target) {
        cumleIt.setText(target);
        int start = cumleIt.first();
        int end = cumleIt.next();
        ArrayList<String> cumleList = new ArrayList<String>();
        while (end != -1) {
            String cumle = target.substring(start, end);
            cumleList.add(cumle);
            start = end;
            end = cumleIt.next();
        }
        return cumleList;
    }

    public static List<YaziBirimi> analizDizisiOlustur(String target) {
        kelimeIt.setText(target);
        int start = kelimeIt.first();
        int end = kelimeIt.next();
        int boslukBasla = 0;
        ArrayList<YaziBirimi> yaziBirimleri = new ArrayList<YaziBirimi>();
        while (end != -1) {
            String word = target.substring(start, end);
            if (Character.isLetterOrDigit(word.charAt(0))) {
                if (boslukBasla < start) {
                    yaziBirimleri.add(new YaziBirimi(YaziBirimiTipi.DIGER, target.substring(boslukBasla, start)));
                }
                yaziBirimleri.add(new YaziBirimi(YaziBirimiTipi.KELIME, word));
                boslukBasla = end;
            }
            start = end;
            end = kelimeIt.next();
        }
        if (boslukBasla < target.length()) {
            yaziBirimleri.add(new YaziBirimi(YaziBirimiTipi.DIGER, target.substring(boslukBasla, target.length())));
        }
        return yaziBirimleri;
    }

    public static String yaziOkuyucu(String fileName) throws IOException {
        String s;
        StringBuffer sb = new StringBuffer();
        FileInputStream fis = new FileInputStream(new File(fileName));
        BufferedReader bis = new BufferedReader(new InputStreamReader((InputStream)fis, "ISO-8859-9"));
        while ((s = bis.readLine()) != null) {
            sb.append(s);
            sb.append("\n");
        }
        bis.close();
        return sb.toString();
    }
}

