/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.araclar;

import java.util.HashMap;
import net.zemberek.araclar.TimerElement;

public class TimeTracker {
    public static int MAX_TIMETRACKER_USERS = 500;
    private static HashMap<String, TimerElement> users = new HashMap();

    public static void startClock(String name) {
        if (users.size() > MAX_TIMETRACKER_USERS) {
            System.err.println("Max Saat izleyici say\u0131s\u0131 a\u015f\u0131ld\u0131. (" + MAX_TIMETRACKER_USERS + ")");
            return;
        }
        if (users.get(name) != null) {
            System.err.println(name + " isminde bir zaman izleyici zaten var.");
            return;
        }
        TimerElement timer = new TimerElement(name);
        users.put(name, timer);
    }

    public static long getElapsedTime(String name) {
        TimerElement timer = users.get(name);
        if (timer == null) {
            return -1L;
        }
        timer.refresh();
        return timer.getElapsedTime();
    }

    public static long getTimeDelta(String name) {
        TimerElement timer = users.get(name);
        if (timer == null) {
            return -1L;
        }
        timer.refresh();
        return timer.getDiff() / 1000L;
    }

    public static String getElapsedTimeString(String name) {
        TimerElement timer = users.get(name);
        if (timer == null) {
            return "Ge\u00e7ersiz Kronometre: " + name;
        }
        timer.refresh();
        return "Delta: " + (double)timer.getDiff() / 1000.0 + " s. Elapsed: " + (double)timer.getElapsedTime() / 1000.0 + " s.";
    }

    public static String getElapsedTimeStringAsMillis(String name) {
        TimerElement timer = users.get(name);
        if (timer == null) {
            return "Ge\u00e7ersiz Kronometre: " + name;
        }
        timer.refresh();
        return "Delta: " + timer.getDiff() / 1000L + "ms. Elapsed: " + timer.getElapsedTime() / 1000L + "ms.";
    }

    public static long getItemsPerSecond(String name, long itemCount) {
        TimerElement timer = users.get(name);
        if (timer == null) {
            return -1L;
        }
        timer.refresh();
        long items = 0L;
        if (timer.getElapsedTime() > 0L) {
            items = itemCount * 1000L / timer.getElapsedTime();
        }
        return items;
    }

    public static String stopClock(String name) {
        TimerElement timer = users.get(name);
        if (timer == null) {
            return name + " : Ge\u00e7ersiz Kronometre";
        }
        timer.refresh();
        users.remove(name);
        return "" + (float)timer.elapsedTime + "sn." + "(" + timer.elapsedTime + " ms.)";
    }
}

