/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.araclar;

import net.zemberek.araclar.JaroWinkler;

public class MetinAraclari {
    private static JaroWinkler jaroWinkler = new JaroWinkler();

    private static int duzeltmeMesafesi(String s, String t, int limit) {
        int n = s.length();
        int m = t.length();
        int[][] d = new int[n + 1][m + 1];
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int i = 0;
        while (i <= n) {
            d[i][0] = i++;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j++;
        }
        for (i = 1; i <= n; ++i) {
            for (int j2 = 1; j2 <= m; ++j2) {
                int cost = t.charAt(j2 - 1) == s.charAt(i - 1) ? 0 : 1;
                d[i][j2] = Math.min(Math.min(d[i - 1][j2] + 1, d[i][j2 - 1] + 1), d[i - 1][j2 - 1] + cost);
                if (i <= 1 || j2 <= 1) continue;
                int trans = d[i - 2][j2 - 2] + 1;
                if (s.charAt(i - 2) != t.charAt(j2 - 1)) {
                    ++trans;
                }
                if (s.charAt(i - 1) != t.charAt(j2 - 2)) {
                    ++trans;
                }
                if (d[i][j2] <= trans) continue;
                d[i][j2] = trans;
            }
        }
        return d[n][m] > limit ? limit + 1 : d[n][m];
    }

    public static boolean duzeltmeMesafesiIcinde(String source, String target, int dist) {
        return MetinAraclari.duzeltmeMesafesi(source, target, dist) <= dist;
    }

    public static boolean parcasiDuzeltmeMesafesiIcinde(String s1, String s2, int distance) {
        if (s2.length() < s1.length() - distance) {
            return false;
        }
        if (s2.length() >= s1.length()) {
            String test = s2.substring(0, s1.length());
            if (MetinAraclari.duzeltmeMesafesiIcinde(s1, test, distance)) {
                return true;
            }
            test = s2.substring(0, s1.length() - 1);
            if (MetinAraclari.duzeltmeMesafesiIcinde(s1, test, distance)) {
                return true;
            }
            if (s2.length() >= s1.length() + 1 && MetinAraclari.duzeltmeMesafesiIcinde(s1, test = s2.substring(0, s1.length() + 1), distance)) {
                return true;
            }
        } else if (MetinAraclari.duzeltmeMesafesiIcinde(s1, s2, distance)) {
            return true;
        }
        return false;
    }

    public static int duzeltmeMesafesi(String source, String target) {
        int maxDif = Math.max(source.length(), target.length());
        return MetinAraclari.duzeltmeMesafesi(source, target, maxDif);
    }

    public static double sozcukBenzerlikOrani(String s1, String s2) {
        return jaroWinkler.benzerlikOrani(s1, s2);
    }

    public static boolean sozcukBenzerlikTesti(String s1, String s2, double enazBenzerlik) {
        return jaroWinkler.benzerlikOrani(s1, s2) >= enazBenzerlik;
    }
}

