/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.araclar;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.zemberek.araclar.KayitBicimleyici;

public class Kayitci {
    private static final ConsoleHandler ch = new ConsoleHandler();

    public static Logger kayitciUret(String ad) {
        return Kayitci.kayitciUret(ad, Level.WARNING);
    }

    public static Logger kayitciUret(String ad, Level level) {
        Logger logger = Logger.getLogger(ad);
        try {
            logger.setUseParentHandlers(false);
            logger.addHandler(ch);
            logger.setLevel(level);
        }
        catch (SecurityException e) {
            System.out.println("Guvenlik erisim problemi. Varsayilan kayitci kullanilacak.");
        }
        return logger;
    }

    public static Logger kayitciUret(Class clazz) {
        return Kayitci.kayitciUret(clazz.getName());
    }

    public static void genelKayitSeviyesiAyarla(String seviye) {
        Handler[] handlers;
        Level l = Level.WARNING;
        if (seviye.equals("INFO")) {
            l = Level.INFO;
        } else if (seviye.equals("FINE")) {
            l = Level.FINE;
        }
        for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
            handler.setLevel(l);
        }
    }

    static {
        try {
            ch.setFormatter(new KayitBicimleyici());
        }
        catch (SecurityException e) {
            System.out.println("Guvenlik erisim problemi. Varsayilan kayit bicimleyici kullanilacak.");
        }
    }
}

