/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.araclar;

public class JaroWinkler {
    public double benzerlikOrani(String source, String target) {
        double dist = this.jaroBenzerlikOrani(source, target);
        if (dist < 0.0 || dist > 1.0) {
            throw new IllegalArgumentException("innerDistance should produce scores between 0 and 1");
        }
        int prefLength = JaroWinkler.commonPrefixLength(4, source, target);
        dist += (double)prefLength * 0.1 * (1.0 - dist);
        return dist;
    }

    private double jaroBenzerlikOrani(String source, String target) {
        int halflen = this.halfLengthOfShorter(source, target);
        String common1 = this.commonChars(source, target, halflen);
        String common2 = this.commonChars(target, source, halflen);
        if (common1.length() != common2.length()) {
            return 0.0;
        }
        if (common1.length() == 0 || common2.length() == 0) {
            return 0.0;
        }
        int transpositions = this.transpositions(common1, common2);
        double dist = ((double)common1.length() / (double)source.length() + (double)common2.length() / (double)target.length() + (double)(common1.length() - transpositions) / (double)common1.length()) / 3.0;
        return dist;
    }

    private int halfLengthOfShorter(String source, String target) {
        return source.length() > target.length() ? target.length() / 2 + 1 : source.length() / 2 + 1;
    }

    private String commonChars(String s, String t, int halflen) {
        StringBuilder common = new StringBuilder();
        StringBuilder copy = new StringBuilder(t);
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            boolean foundIt = false;
            for (int j = Math.max(0, i - halflen); !foundIt && j < Math.min(i + halflen, t.length()); ++j) {
                if (copy.charAt(j) != ch) continue;
                foundIt = true;
                common.append(ch);
                copy.setCharAt(j, '*');
            }
        }
        return common.toString();
    }

    private int transpositions(String common1, String common2) {
        int transpositions = 0;
        for (int i = 0; i < common1.length(); ++i) {
            if (common1.charAt(i) == common2.charAt(i)) continue;
            ++transpositions;
        }
        return transpositions /= 2;
    }

    private static int commonPrefixLength(int maxLength, String common1, String common2) {
        int n = Math.min(maxLength, Math.min(common1.length(), common2.length()));
        for (int i = 0; i < n; ++i) {
            if (common1.charAt(i) == common2.charAt(i)) continue;
            return i;
        }
        return n;
    }
}

