/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.zemberek.demo.SwingFactory;

public class GirisAlani {
    private JPanel mainPanel;
    private JTextArea inputArea;
    private char[] ozelKarakterler;
    private JPanel buttonPanel;

    public GirisAlani(char[] cArray) {
        this.ozelKarakterler = cArray;
        this.configure();
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void setYazi(String string) {
        this.inputArea.setText(string);
    }

    public String getYazi() {
        return this.inputArea.getText();
    }

    private void configure() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(new TitledBorder(new EmptyBorder(2, 2, 2, 2), "Giri\u015f alan\u0131"));
        this.ozelKarakterDugmeAlaniOlustur(this.ozelKarakterler);
        this.mainPanel.add((Component)this.makeInputPanel(), "Center");
    }

    private JPanel makeInputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.inputArea = new JTextArea();
        this.inputArea.setBorder(new EmptyBorder(1, 3, 1, 3));
        this.inputArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.inputArea);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public void ozelKarakterDugmeAlaniOlustur(char[] cArray) {
        if (this.buttonPanel != null) {
            this.mainPanel.remove(this.buttonPanel);
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(0, 5, 5));
        for (char c : cArray) {
            JButton jButton = SwingFactory.getRegularButton(String.valueOf(c));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ((JButton)actionEvent.getSource()).getText();
                    int n = GirisAlani.this.inputArea.getCaretPosition();
                    GirisAlani.this.inputArea.insert(string, n);
                    GirisAlani.this.inputArea.setCaretPosition(n + 1);
                    GirisAlani.this.inputArea.requestFocus();
                }
            });
            this.buttonPanel.add(jButton);
        }
        this.mainPanel.add((Component)this.buttonPanel, "North");
        this.mainPanel.repaint();
        this.mainPanel.validate();
    }
}

