/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.demo;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.zemberek.araclar.Kayitci;
import net.zemberek.araclar.turkce.YaziBirimi;
import net.zemberek.araclar.turkce.YaziBirimiTipi;
import net.zemberek.araclar.turkce.YaziIsleyici;
import net.zemberek.demo.IslemTipi;
import net.zemberek.demo.TurkDiliTuru;
import net.zemberek.erisim.Zemberek;
import net.zemberek.yapi.DilBilgisi;
import net.zemberek.yapi.Kelime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoYonetici {
    private static Logger logger = Kayitci.kayitciUret(DemoYonetici.class);
    private Zemberek zemberek;
    private DilBilgisi dilBilgisi;
    private Map<TurkDiliTuru, Zemberek> zemberekler = new HashMap<TurkDiliTuru, Zemberek>();

    public DemoYonetici() {
        try {
            this.dilSec(TurkDiliTuru.TURKIYE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.warning("ilgili dil ayarlari sinifi " + TurkDiliTuru.TURKIYE.sinif() + " icin bulunamiyor..");
        }
    }

    public void dilSec(TurkDiliTuru turkDiliTuru) throws ClassNotFoundException {
        if (this.zemberekler.get((Object)turkDiliTuru) == null) {
            this.zemberekler.put(turkDiliTuru, turkDiliTuru.zemberekUret());
            this.zemberek = this.zemberekler.get((Object)turkDiliTuru);
            this.dilBilgisi = this.zemberek.dilBilgisi();
        }
    }

    public char[] ozelKarakterDizisiGetir() {
        return this.dilBilgisi.alfabe().asciiDisiHarfler();
    }

    public String islemUygula(String string, String string2) {
        try {
            IslemTipi islemTipi = IslemTipi.valueOf(string);
            return this.islemUygula(islemTipi, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.severe("istenilen islem:" + string + " mevcut degil");
            return "";
        }
    }

    public String islemUygula(IslemTipi islemTipi, String string) {
        switch (islemTipi) {
            case YAZI_DENETLE: {
                return this.yaziDenetle(string);
            }
            case YAZI_COZUMLE: {
                return this.yaziCozumle(string);
            }
            case ASCII_TURKCE: {
                return this.asciiToTurkceTahmin(string);
            }
            case TURKCE_ASCII: {
                return this.turkceToAscii(string);
            }
            case HECELE: {
                return this.hecele(string);
            }
            case ONER: {
                return this.oner(string);
            }
        }
        return "";
    }

    public String yaziDenetle(String string) {
        List list = YaziIsleyici.analizDizisiOlustur((String)string);
        StringBuffer stringBuffer = new StringBuffer();
        for (YaziBirimi yaziBirimi : list) {
            if (yaziBirimi.tip == YaziBirimiTipi.KELIME) {
                if (!this.zemberek.kelimeDenetle(yaziBirimi.icerik)) {
                    stringBuffer.append(this.hataliKelimeBicimle(yaziBirimi.icerik));
                    continue;
                }
                stringBuffer.append(yaziBirimi.icerik);
                continue;
            }
            stringBuffer.append(this.kelimeHariciBicimle(yaziBirimi.icerik));
        }
        return stringBuffer.toString();
    }

    public String yaziCozumle(String string) {
        List list = YaziIsleyici.analizDizisiOlustur((String)string);
        StringBuffer stringBuffer = new StringBuffer();
        for (YaziBirimi yaziBirimi : list) {
            if (yaziBirimi.tip != YaziBirimiTipi.KELIME) continue;
            Kelime[] kelimeArray = this.zemberek.kelimeCozumle(yaziBirimi.icerik);
            stringBuffer.append(yaziBirimi.icerik).append("<br>");
            if (kelimeArray.length == 0) {
                stringBuffer.append(" :cozulemedi<br>");
                continue;
            }
            for (Kelime kelime : kelimeArray) {
                stringBuffer.append(kelime).append("<br>");
            }
        }
        return stringBuffer.toString();
    }

    public String asciiToTurkce(String string) {
        List list = YaziIsleyici.analizDizisiOlustur((String)string);
        StringBuffer stringBuffer = new StringBuffer();
        for (YaziBirimi yaziBirimi : list) {
            if (yaziBirimi.tip == YaziBirimiTipi.KELIME) {
                Kelime[] kelimeArray = this.zemberek.asciiCozumle(yaziBirimi.icerik);
                HashSet<String> hashSet = new HashSet<String>(2);
                for (Kelime kelime : kelimeArray) {
                    hashSet.add(kelime.icerik().toString());
                }
                if (hashSet.size() == 0) {
                    stringBuffer.append(this.hataliKelimeBicimle(yaziBirimi.icerik));
                    continue;
                }
                if (hashSet.size() == 1) {
                    stringBuffer.append((String)hashSet.iterator().next());
                    continue;
                }
                stringBuffer.append(this.koseliParantezStringDiziBicimle(hashSet, " "));
                continue;
            }
            stringBuffer.append(this.kelimeHariciBicimle(yaziBirimi.icerik));
        }
        return stringBuffer.toString();
    }

    private String kelimeHariciBicimle(String string) {
        if (string.equals("\n")) {
            return "<br>";
        }
        return string;
    }

    public String asciiToTurkceTahmin(String string) {
        List list = YaziIsleyici.analizDizisiOlustur((String)string);
        StringBuffer stringBuffer = new StringBuffer();
        for (YaziBirimi yaziBirimi : list) {
            if (yaziBirimi.tip == YaziBirimiTipi.KELIME) {
                Kelime[] kelimeArray = this.zemberek.asciiCozumle(yaziBirimi.icerik);
                if (kelimeArray.length > 0) {
                    stringBuffer.append(this.applyCase(yaziBirimi.icerik, kelimeArray[0].icerik().toString()));
                    continue;
                }
                stringBuffer.append(yaziBirimi.icerik);
                continue;
            }
            stringBuffer.append(this.kelimeHariciBicimle(yaziBirimi.icerik));
        }
        return stringBuffer.toString();
    }

    private String applyCase(String string, String string2) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (!Character.isUpperCase(cArray[i])) continue;
            cArray2[i] = this.dilBilgisi.alfabe().buyukHarf(cArray2[i]).charDeger();
        }
        return new String(cArray2);
    }

    public String turkceToAscii(String string) {
        List list = YaziIsleyici.analizDizisiOlustur((String)string);
        StringBuffer stringBuffer = new StringBuffer();
        for (YaziBirimi yaziBirimi : list) {
            if (yaziBirimi.tip == YaziBirimiTipi.KELIME) {
                stringBuffer.append(this.zemberek.asciiyeDonustur(yaziBirimi.icerik));
                continue;
            }
            stringBuffer.append(this.kelimeHariciBicimle(yaziBirimi.icerik));
        }
        return stringBuffer.toString();
    }

    public String hecele(String string) {
        List list = YaziIsleyici.analizDizisiOlustur((String)string);
        StringBuffer stringBuffer = new StringBuffer();
        for (YaziBirimi yaziBirimi : list) {
            if (yaziBirimi.tip == YaziBirimiTipi.KELIME) {
                yaziBirimi.icerik = this.dilBilgisi.alfabe().ayikla(yaziBirimi.icerik);
                if (!this.dilBilgisi.alfabe().cozumlemeyeUygunMu(yaziBirimi.icerik)) {
                    stringBuffer.append(this.hataliKelimeBicimle(yaziBirimi.icerik));
                    continue;
                }
                String[] stringArray = this.zemberek.hecele(yaziBirimi.icerik);
                if (stringArray.length == 0) {
                    stringBuffer.append(this.hataliKelimeBicimle(yaziBirimi.icerik));
                    continue;
                }
                stringBuffer.append(this.koseliParantezStringDiziBicimle(stringArray, "-"));
                continue;
            }
            stringBuffer.append(yaziBirimi.icerik);
        }
        return stringBuffer.toString();
    }

    public String oner(String string) {
        List list = YaziIsleyici.analizDizisiOlustur((String)string);
        StringBuffer stringBuffer = new StringBuffer();
        for (YaziBirimi yaziBirimi : list) {
            if (yaziBirimi.tip == YaziBirimiTipi.KELIME) {
                String[] stringArray = this.zemberek.oner(yaziBirimi.icerik);
                if (stringArray.length == 0) {
                    stringBuffer.append(this.hataliKelimeBicimle(yaziBirimi.icerik));
                    continue;
                }
                if (stringArray.length == 1) {
                    stringBuffer.append(stringArray[0]);
                    continue;
                }
                stringBuffer.append(this.koseliParantezStringDiziBicimle(stringArray, ", "));
                continue;
            }
            stringBuffer.append(yaziBirimi.icerik);
        }
        return stringBuffer.toString();
    }

    private String koseliParantezStringDiziBicimle(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(string);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String koseliParantezStringDiziBicimle(Collection<String> collection, String string) {
        return this.koseliParantezStringDiziBicimle(collection.toArray(new String[collection.size()]), string);
    }

    private String hataliKelimeBicimle(String string) {
        return "<font color=\"#FF0033\">" + string + "</font>";
    }
}

