/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.tr.yapi.kok;

import java.util.ArrayList;
import java.util.HashMap;
import net.zemberek.tr.yapi.kok.TurkceKokOzelDurumTipleri;
import net.zemberek.tr.yapi.kok.YumusamaNk;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.Kisaltma;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.ek.EkYonetici;
import net.zemberek.yapi.kok.AraSesliDusmesi;
import net.zemberek.yapi.kok.BosHarfDizisiIslemi;
import net.zemberek.yapi.kok.Ciftleme;
import net.zemberek.yapi.kok.HarfDizisiIslemi;
import net.zemberek.yapi.kok.KokOzelDurumBilgisi;
import net.zemberek.yapi.kok.KokOzelDurumTipi;
import net.zemberek.yapi.kok.KokOzelDurumu;
import net.zemberek.yapi.kok.SonHarfDusmesi;
import net.zemberek.yapi.kok.SonSesliIncelt;
import net.zemberek.yapi.kok.TemelKokOzelDurumBilgisi;
import net.zemberek.yapi.kok.Ulama;
import net.zemberek.yapi.kok.YeniIcerikAta;
import net.zemberek.yapi.kok.Yumusama;

public class TurkceKokOzelDurumBilgisi
extends TemelKokOzelDurumBilgisi
implements KokOzelDurumBilgisi {
    private static final String[] BOS_STRING_DIZISI = new String[0];

    private void uret() {
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.SESSIZ_YUMUSAMASI, (HarfDizisiIslemi)new Yumusama()).sesliEkIleOlusur(true).yapiBozucu(true));
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.SESSIZ_YUMUSAMASI_NK, new YumusamaNk(this.alfabe)).sesliEkIleOlusur(true).yapiBozucu(true));
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.ISIM_SESLI_DUSMESI, (HarfDizisiIslemi)new AraSesliDusmesi()).yapiBozucu(true));
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.CIFTLEME, (HarfDizisiIslemi)new Ciftleme()).sesliEkIleOlusur(true).yapiBozucu(true));
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.FIIL_ARA_SESLI_DUSMESI, (HarfDizisiIslemi)new AraSesliDusmesi()).yapiBozucu(true));
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.KUCULTME, (HarfDizisiIslemi)new SonHarfDusmesi()).yapiBozucu(true));
        HashMap<String, String> benSenDonusum = new HashMap<String, String>();
        benSenDonusum.put("ben", "ban");
        benSenDonusum.put("sen", "san");
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.TEKIL_KISI_BOZULMASI, (HarfDizisiIslemi)new YeniIcerikAta(this.alfabe, benSenDonusum)).yapiBozucu(true));
        HashMap<String, String> deYeDonusum = new HashMap<String, String>();
        deYeDonusum.put("de", "di");
        deYeDonusum.put("ye", "yi");
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.FIIL_KOK_BOZULMASI, (HarfDizisiIslemi)new YeniIcerikAta(this.alfabe, deYeDonusum)).yapiBozucu(true));
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.TERS_SESLI_EK, (HarfDizisiIslemi)new SonSesliIncelt(this.alfabe)).yapiBozucu(true).herZamanOlusur(true));
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.SIMDIKI_ZAMAN, (HarfDizisiIslemi)new SonHarfDusmesi()).yapiBozucu(true).otomatikBelirlenir(true));
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.ISIM_SON_SESLI_DUSMESI, (HarfDizisiIslemi)new SonHarfDusmesi()).secimlik(true).yapiBozucu(true));
        HarfDizisi n = new HarfDizisi("n", this.alfabe);
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.ZAMIR_SESLI_OZEL, (HarfDizisiIslemi)new Ulama(n)).yapiBozucu(true));
        this.ekle(this.uretici(TurkceKokOzelDurumTipleri.ISIM_TAMLAMASI, (HarfDizisiIslemi)new BosHarfDizisiIslemi()).ekKisitlayici(true));
        this.bosOzelDurumEkle(new KokOzelDurumTipi[]{TurkceKokOzelDurumTipleri.YALIN, TurkceKokOzelDurumTipleri.EK_OZEL_DURUMU, TurkceKokOzelDurumTipleri.GENIS_ZAMAN, TurkceKokOzelDurumTipleri.FIIL_GECISSIZ, TurkceKokOzelDurumTipleri.KAYNASTIRMA_N, TurkceKokOzelDurumTipleri.KESMESIZ, TurkceKokOzelDurumTipleri.TIRE, TurkceKokOzelDurumTipleri.KESME, TurkceKokOzelDurumTipleri.OZEL_IC_KARAKTER, TurkceKokOzelDurumTipleri.ZAMIR_IM, TurkceKokOzelDurumTipleri.ZAMIR_IN, TurkceKokOzelDurumTipleri.KISALTMA_SON_SESLI, TurkceKokOzelDurumTipleri.KISALTMA_SON_SESSIZ, TurkceKokOzelDurumTipleri.SU_OZEL_DURUMU});
    }

    public TurkceKokOzelDurumBilgisi(EkYonetici ekler, Alfabe alfabe) {
        super(ekler, alfabe);
        this.uret();
    }

    public String[] ozelDurumUygula(Kok kok) {
        if (!kok.ozelDurumVarmi()) {
            return BOS_STRING_DIZISI;
        }
        HarfDizisi hdizi = new HarfDizisi(kok.icerik(), this.alfabe);
        ArrayList<String> degismisIcerikler = new ArrayList<String>(1);
        boolean eskiSonsesliInce = false;
        if (kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.ISIM_SESLI_DUSMESI)) {
            eskiSonsesliInce = hdizi.sonSesli().inceSesliMi();
        }
        boolean yapiBozucuOzelDurumvar = false;
        if (kok.ozelDurumDizisi().length == 1 && kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.TERS_SESLI_EK)) {
            return new String[0];
        }
        for (KokOzelDurumu ozelDurum : kok.ozelDurumDizisi()) {
            if (ozelDurum == null) {
                logger.warning("null ozel durum!. Kok:" + kok);
                return new String[0];
            }
            if (!ozelDurum.equals((Object)this.ozelDurum(TurkceKokOzelDurumTipleri.KUCULTME))) {
                ozelDurum.uygula(hdizi);
            }
            if (!ozelDurum.yapiBozucumu()) continue;
            yapiBozucuOzelDurumvar = true;
        }
        if ((kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.ISIM_SESLI_DUSMESI) || kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.FIIL_ARA_SESLI_DUSMESI)) && !hdizi.sonSesli().inceSesliMi() && eskiSonsesliInce) {
            kok.ozelDurumEkle((KokOzelDurumu)this.ozelDurumlar.get((Object)TurkceKokOzelDurumTipleri.TERS_SESLI_EK));
        }
        if (yapiBozucuOzelDurumvar) {
            degismisIcerikler.add(hdizi.toString());
        }
        if (kok.ozelDurumVarmi() && kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.KUCULTME) && kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.SESSIZ_YUMUSAMASI)) {
            HarfDizisi tempDizi = new HarfDizisi(kok.icerik(), this.alfabe);
            this.ozelDurum(TurkceKokOzelDurumTipleri.KUCULTME).uygula(tempDizi);
            degismisIcerikler.add(tempDizi.toString());
        }
        return degismisIcerikler.toArray(new String[degismisIcerikler.size()]);
    }

    public void ozelDurumBelirle(Kok kok) {
        char sonChar = kok.icerik().charAt(kok.icerik().length() - 1);
        if (kok.tip() == KelimeTipi.FIIL && this.alfabe.harf(sonChar).sesliMi() && !kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.FIIL_KOK_BOZULMASI)) {
            kok.ozelDurumEkle((KokOzelDurumu)this.ozelDurumlar.get((Object)TurkceKokOzelDurumTipleri.SIMDIKI_ZAMAN));
        }
    }

    public void duzyaziOzelDurumOku(Kok kok, String okunanIcerik, String[] parcalar) {
        for (int i = 2; i < parcalar.length; ++i) {
            String ozelDurum = parcalar[i];
            if (ozelDurum.startsWith(TurkceKokOzelDurumTipleri.OZEL_IC_KARAKTER.kisaAd())) {
                kok.ozelDurumEkle((KokOzelDurumu)this.ozelDurumlar.get((Object)TurkceKokOzelDurumTipleri.OZEL_IC_KARAKTER));
            }
            if (ozelDurum.startsWith(TurkceKokOzelDurumTipleri.KISALTMA_SON_SESLI.kisaAd())) {
                int loc = ozelDurum.indexOf(58);
                if (loc > 0) {
                    String parca = ozelDurum.substring(loc + 1);
                    char sonSesli = parca.charAt(0);
                    if (!this.alfabe.harf(sonSesli).sesliMi()) {
                        logger.warning("Hatali kisaltma harfi.. Sesli bekleniyordu." + ozelDurum);
                    }
                    Kisaltma kis = (Kisaltma)kok;
                    kis.setKisaltmaSonSeslisi(sonSesli);
                    if (parca.length() > 1) {
                        kok.ozelDurumEkle((KokOzelDurumu)this.ozelDurumlar.get((Object)TurkceKokOzelDurumTipleri.KISALTMA_SON_SESSIZ));
                        continue;
                    }
                    kok.ozelDurumCikar((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.KISALTMA_SON_SESLI);
                    continue;
                }
                char sonHarf = kok.icerik().charAt(kok.icerik().length() - 1);
                if (this.alfabe.harf(sonHarf).sesliMi()) continue;
                ((Kisaltma)kok).setKisaltmaSonSeslisi('e');
                kok.ozelDurumEkle((KokOzelDurumu)this.ozelDurumlar.get((Object)TurkceKokOzelDurumTipleri.KISALTMA_SON_SESLI));
                continue;
            }
            KokOzelDurumu oz = this.ozelDurum(ozelDurum);
            if (oz != null) {
                kok.ozelDurumEkle(oz);
                continue;
            }
            logger.warning("Hatali kok bileseni" + kok.icerik() + " Token: " + ozelDurum);
        }
        if (kok.tip() != KelimeTipi.KISALTMA && !kok.ozelDurumIceriyormu((KokOzelDurumTipi)TurkceKokOzelDurumTipleri.OZEL_IC_KARAKTER)) {
            kok.setAsil(null);
        } else {
            kok.ozelDurumEkle((KokOzelDurumu)this.ozelDurumlar.get((Object)TurkceKokOzelDurumTipleri.OZEL_IC_KARAKTER));
        }
    }

    public void kokIcerikIsle(Kok kok, KelimeTipi tip, String icerik) {
        if (tip.equals((Object)KelimeTipi.KISALTMA)) {
            kok.setAsil(icerik);
        }
        if (tip.equals((Object)KelimeTipi.FIIL) && (icerik.endsWith("mek") || icerik.endsWith("mak"))) {
            icerik = icerik.substring(0, icerik.length() - 3);
            kok.setIcerik(icerik);
        }
    }
}

