/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.tr.yapi;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.zemberek.tr.islemler.TurkceCozumlemeYardimcisi;
import net.zemberek.tr.yapi.TurkceHeceleyici;
import net.zemberek.tr.yapi.ek.EkUreticiTr;
import net.zemberek.tr.yapi.ek.TurkceEkOzelDurumUretici;
import net.zemberek.tr.yapi.kok.TurkceKokOzelDurumBilgisi;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.DilAyarlari;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.ek.EkKuralBilgisi;
import net.zemberek.yapi.ek.EkOzelDurumUretici;
import net.zemberek.yapi.ek.EkUretici;
import net.zemberek.yapi.ek.TemelEkUretimKurali;
import net.zemberek.yapi.ek.TemelEkYonetici;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurkiyeTurkcesi
implements DilAyarlari {
    public static final Locale LOCALE_TR = new Locale("tr");

    public Locale locale() {
        return LOCALE_TR;
    }

    public Class alfabeSinifi() {
        return Alfabe.class;
    }

    public Class ekYoneticiSinifi() {
        return TemelEkYonetici.class;
    }

    public Class heceleyiciSinifi() {
        return TurkceHeceleyici.class;
    }

    public Class kokOzelDurumBilgisiSinifi() {
        return TurkceKokOzelDurumBilgisi.class;
    }

    public Class cozumlemeYardimcisiSinifi() {
        return TurkceCozumlemeYardimcisi.class;
    }

    public EkUretici ekUretici(Alfabe alfabe) {
        return new EkUreticiTr(alfabe);
    }

    public EkOzelDurumUretici ekOzelDurumUretici(Alfabe alfabe) {
        return new TurkceEkOzelDurumUretici(alfabe);
    }

    public String[] duzYaziKokDosyalari() {
        return new String[]{"kaynaklar/tr/bilgi/duzyazi-kilavuz.txt", "kaynaklar/tr/bilgi/kisaltmalar.txt", "kaynaklar/tr/bilgi/bilisim.txt", "kaynaklar/tr/bilgi/kisi-adlari.txt"};
    }

    public EkKuralBilgisi ekKuralBilgisi() {
        return new TemelEkUretimKurali.TemelKuralBilgisi();
    }

    public Map<String, KelimeTipi> kokTipiAdlari() {
        HashMap<String, KelimeTipi> tipMap = new HashMap<String, KelimeTipi>();
        tipMap.put("IS", KelimeTipi.ISIM);
        tipMap.put("FI", KelimeTipi.FIIL);
        tipMap.put("SI", KelimeTipi.SIFAT);
        tipMap.put("SA", KelimeTipi.SAYI);
        tipMap.put("YA", KelimeTipi.YANKI);
        tipMap.put("ZA", KelimeTipi.ZAMIR);
        tipMap.put("SO", KelimeTipi.SORU);
        tipMap.put("IM", KelimeTipi.IMEK);
        tipMap.put("ZAMAN", KelimeTipi.ZAMAN);
        tipMap.put("HATALI", KelimeTipi.HATALI);
        tipMap.put("EDAT", KelimeTipi.EDAT);
        tipMap.put("BAGLAC", KelimeTipi.BAGLAC);
        tipMap.put("OZ", KelimeTipi.OZEL);
        tipMap.put("UN", KelimeTipi.UNLEM);
        tipMap.put("KI", KelimeTipi.KISALTMA);
        return tipMap;
    }

    public Map<KelimeTipi, String> baslangiEkAdlari() {
        EnumMap<KelimeTipi, String> baslangicEkAdlari = new EnumMap<KelimeTipi, String>(KelimeTipi.class);
        baslangicEkAdlari.put(KelimeTipi.ISIM, "ISIM_KOK");
        baslangicEkAdlari.put(KelimeTipi.SIFAT, "ISIM_KOK");
        baslangicEkAdlari.put(KelimeTipi.FIIL, "FIIL_KOK");
        baslangicEkAdlari.put(KelimeTipi.ZAMAN, "ZAMAN_KOK");
        baslangicEkAdlari.put(KelimeTipi.ZAMIR, "ZAMIR_KOK");
        baslangicEkAdlari.put(KelimeTipi.SAYI, "SAYI_KOK");
        baslangicEkAdlari.put(KelimeTipi.SORU, "SORU_KOK");
        baslangicEkAdlari.put(KelimeTipi.UNLEM, "UNLEM_KOK");
        baslangicEkAdlari.put(KelimeTipi.EDAT, "EDAT_KOK");
        baslangicEkAdlari.put(KelimeTipi.BAGLAC, "BAGLAC_KOK");
        baslangicEkAdlari.put(KelimeTipi.OZEL, "OZEL_KOK");
        baslangicEkAdlari.put(KelimeTipi.IMEK, "IMEK_KOK");
        baslangicEkAdlari.put(KelimeTipi.YANKI, "YANKI_KOK");
        baslangicEkAdlari.put(KelimeTipi.KISALTMA, "ISIM_KOK");
        return baslangicEkAdlari;
    }

    public String ad() {
        return "Turkiye Turkcesi";
    }
}

