/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi.ek;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.zemberek.araclar.Kayitci;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.ek.EkYonetici;
import net.zemberek.yapi.ek.XmlEkOkuyucu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemelEkYonetici
implements EkYonetici {
    protected static Logger logger = Kayitci.kayitciUret(TemelEkYonetici.class);
    public static final Ek BOS_EK = new Ek("BOS_EK");
    protected Map<String, Ek> ekler;
    protected Map<KelimeTipi, Ek> baslangicEkleri = new HashMap<KelimeTipi, Ek>();

    public TemelEkYonetici(Map<KelimeTipi, String> baslangicEkMap, XmlEkOkuyucu okuyucu) throws IOException {
        long start = System.currentTimeMillis();
        okuyucu.xmlOku();
        this.ekler = okuyucu.getEkler();
        for (KelimeTipi tip : baslangicEkMap.keySet()) {
            Ek ek = this.ekler.get(baslangicEkMap.get((Object)tip));
            if (ek != null) {
                this.baslangicEkleri.put(tip, ek);
                continue;
            }
            logger.warning((Object)((Object)tip) + " tipi icin baslangic eki " + baslangicEkMap.get((Object)tip) + " bulunamiyor!");
        }
        logger.fine("ek okuma ve olusum suresii: " + (System.currentTimeMillis() - start) + "ms.");
    }

    @Override
    public Ek ek(String ekId) {
        Ek ek = this.ekler.get(ekId);
        if (ek == null) {
            logger.severe("Ek bulunamiyor!" + ekId);
        }
        return this.ekler.get(ekId);
    }

    @Override
    public Ek ilkEkBelirle(Kok kok) {
        Ek baslangicEki = this.baslangicEkleri.get((Object)kok.tip());
        if (baslangicEki != null) {
            return baslangicEki;
        }
        return BOS_EK;
    }
}

