/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi.ek;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.zemberek.islemler.cozumleme.HarfDizisiKiyaslayici;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.TurkceHarf;
import net.zemberek.yapi.ek.EkOzelDurumu;
import net.zemberek.yapi.ek.EkUretici;
import net.zemberek.yapi.ek.EkUretimBileseni;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ek {
    private List<Ek> ardisilEkler = new ArrayList<Ek>();
    private String ad;
    private boolean sesliIleBaslayabilir = false;
    private EkUretici ekUretici;
    private List<EkUretimBileseni> uretimBilesenleri;
    private List<EkOzelDurumu> ozelDurumlar = new ArrayList<EkOzelDurumu>(1);
    private boolean sonEkOlamaz = false;
    private boolean halEki = false;
    private boolean iyelikEki = false;
    private Set<TurkceHarf> baslangicHarfleri;

    public void baslangicHarfleriEkle(Set<TurkceHarf> harfler) {
        if (harfler == null) {
            return;
        }
        if (this.baslangicHarfleri == null) {
            this.baslangicHarfleri = new HashSet<TurkceHarf>(5);
        }
        this.baslangicHarfleri.addAll(harfler);
    }

    public void setHalEki(boolean halEki) {
        this.halEki = halEki;
    }

    public void setIyelikEki(boolean iyelikEki) {
        this.iyelikEki = iyelikEki;
    }

    public boolean halEkiMi() {
        return this.halEki;
    }

    public boolean iyelikEkiMi() {
        return this.iyelikEki;
    }

    public HarfDizisi cozumlemeIcinUret(Kelime kelime, HarfDizisi giris, HarfDizisiKiyaslayici kiyaslayici) {
        for (EkOzelDurumu ozelDurum : this.ozelDurumlar) {
            HarfDizisi ozelDurumSonucu = ozelDurum.cozumlemeIcinUret(kelime, giris, kiyaslayici);
            if (ozelDurumSonucu == null) continue;
            return ozelDurumSonucu;
        }
        return this.ekUretici.cozumlemeIcinEkUret(kelime.icerik(), giris, this.uretimBilesenleri);
    }

    public HarfDizisi olusumIcinUret(Kelime kelime, Ek sonrakiEk) {
        for (EkOzelDurumu ozelDurum : this.ozelDurumlar) {
            HarfDizisi ozelDurumSonucu = ozelDurum.olusumIcinUret(kelime, sonrakiEk);
            if (ozelDurumSonucu == null) continue;
            return ozelDurumSonucu;
        }
        return this.ekUretici.olusumIcinEkUret(kelime.icerik(), sonrakiEk, this.uretimBilesenleri);
    }

    public void setOzelDurumlar(List<EkOzelDurumu> ozelDurumlar) {
        this.ozelDurumlar = ozelDurumlar;
    }

    public boolean ardindanGelebilirMi(Ek ek) {
        return this.ardisilEkler.contains(ek);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ek ek = (Ek)o;
        return !(this.ad == null ? ek.ad != null : !this.ad.equals(ek.ad));
    }

    public int hashCode() {
        return this.ad != null ? this.ad.hashCode() : 0;
    }

    public boolean sesliIleBaslayabilirMi() {
        return this.sesliIleBaslayabilir;
    }

    public String toString() {
        return this.ad;
    }

    public Ek(String name) {
        this.ad = name;
    }

    public String ad() {
        return this.ad;
    }

    public Ek getArdisilEk(int ardisilEkSirasi) {
        if (ardisilEkSirasi < this.ardisilEkler.size()) {
            return this.ardisilEkler.get(ardisilEkSirasi);
        }
        return null;
    }

    public boolean OzelEkOlustur(Kelime ozelKelime) {
        return false;
    }

    public List<Ek> ardisilEkler() {
        return this.ardisilEkler;
    }

    public void setArdisilEkler(List<Ek> ardisilEkler) {
        this.ardisilEkler = ardisilEkler;
    }

    public void setSesliIleBaslayabilir(boolean sesliIleBaslayabilir) {
        this.sesliIleBaslayabilir = sesliIleBaslayabilir;
    }

    public void setEkKuralCozumleyici(EkUretici ekUretici) {
        this.ekUretici = ekUretici;
    }

    public void setUretimBilesenleri(List<EkUretimBileseni> uretimBilesenleri) {
        this.uretimBilesenleri = uretimBilesenleri;
    }

    public boolean sonEkOlamazMi() {
        return this.sonEkOlamaz;
    }

    public List<EkUretimBileseni> uretimBilesenleri() {
        return this.uretimBilesenleri;
    }

    public void setSonEkOlamaz(boolean sonEkOlamaz) {
        this.sonEkOlamaz = sonEkOlamaz;
    }

    public boolean ilkHarfDenetle(TurkceHarf ilkHarf) {
        return this.baslangicHarfleri == null || this.baslangicHarfleri.contains(ilkHarf);
    }
}

