/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi;

import java.util.ArrayList;
import java.util.List;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.TurkceHarf;
import net.zemberek.yapi.ek.Ek;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kelime
implements Cloneable {
    private static final HarfDizisi BOS_ICERIK = new HarfDizisi(0);
    private HarfDizisi icerik = BOS_ICERIK;
    private Kok kok;
    private List<Ek> ekler = new ArrayList<Ek>(3);
    private KelimeTipi tip;

    public Kelime() {
    }

    public Ek[] ekDizisi() {
        return this.ekler.toArray(new Ek[this.ekler.size()]);
    }

    public Kelime clone() {
        try {
            Kelime kopya = (Kelime)super.clone();
            kopya.icerik = new HarfDizisi(this.icerik);
            kopya.ekler = new ArrayList<Ek>(this.ekler);
            return kopya;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone is supported, this can not happen " + e.getMessage());
        }
    }

    public List<Ek> ekler() {
        return this.ekler;
    }

    public String ekZinciriStr() {
        StringBuilder buf = new StringBuilder();
        for (Ek ek : this.ekler) {
            buf.append(ek.ad()).append(", ");
        }
        if (buf.length() > 2) {
            buf.delete(buf.length() - 2, buf.length());
        }
        return buf.toString();
    }

    public Kelime(Kok kok, Alfabe alfabe) {
        this.kok = kok;
        this.icerik = new HarfDizisi(kok.icerik(), alfabe);
        this.tip = kok.tip();
    }

    public Kelime(Kok kok, HarfDizisi dizi) {
        this.kok = kok;
        this.icerik = dizi;
        this.tip = kok.tip();
    }

    public void setIcerik(HarfDizisi icerik) {
        this.icerik = icerik;
    }

    public int ekSayisi() {
        return this.ekler.size();
    }

    public TurkceHarf sonHarf() {
        return this.icerik.sonHarf();
    }

    public HarfDizisi icerik() {
        return this.icerik;
    }

    public int boy() {
        return this.icerik.length();
    }

    public Ek sonEk() {
        return this.ekler.get(this.ekler.size() - 1);
    }

    public String icerikStr() {
        return this.icerik.toString();
    }

    public void ekEkle(Ek ek) {
        this.ekler.add(ek);
    }

    public boolean ekVarmi(String ekAdi) {
        for (Ek ek : this.ekler) {
            if (!ek.ad().equalsIgnoreCase(ekAdi)) continue;
            return true;
        }
        return false;
    }

    public Kok kok() {
        return this.kok;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(" [ Kok: " + this.kok.icerik() + ", " + (Object)((Object)this.kok.tip()) + " ] ");
        if (this.ekler.size() > 1) {
            str.append(" Ekler: ");
        }
        for (int i = 1; i < this.ekler.size(); ++i) {
            str.append(this.ekler.get(i).ad());
            if (i >= this.ekler.size() - 1) continue;
            str.append(" + ");
        }
        return str.toString();
    }

    public void icerikEkle(HarfDizisi eklenecek) {
        this.icerik.ekle(eklenecek);
    }

    public boolean gercekEkYok() {
        return this.ekler.size() < 2;
    }
}

