/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi;

import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.TurkceHarf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HarfDizisi
implements CharSequence,
Comparable<HarfDizisi> {
    private TurkceHarf[] dizi;
    private int boy = 0;
    public static final HarfDizisi BOS_DIZI = new HarfDizisi(0);

    public HarfDizisi() {
        this.dizi = new TurkceHarf[7];
    }

    public HarfDizisi(int kapasite) {
        this.dizi = new TurkceHarf[kapasite];
    }

    public HarfDizisi(String str, Alfabe alfabe, int kapasite) {
        if (kapasite < str.length()) {
            kapasite = str.length();
        }
        this.dizi = new TurkceHarf[kapasite];
        this.boy = str.length();
        for (int i = 0; i < this.boy; ++i) {
            this.dizi[i] = alfabe.harf(str.charAt(i));
        }
    }

    public HarfDizisi(String str, Alfabe alfabe) {
        this.boy = str.length();
        this.dizi = new TurkceHarf[this.boy];
        for (int i = 0; i < this.boy; ++i) {
            this.dizi[i] = alfabe.harf(str.charAt(i));
        }
    }

    public HarfDizisi(HarfDizisi hdizi) {
        this.boy = hdizi.length();
        this.dizi = new TurkceHarf[this.boy];
        System.arraycopy(hdizi.dizi, 0, this.dizi, 0, this.boy);
    }

    private HarfDizisi(TurkceHarf[] inpDizi) {
        this.boy = inpDizi.length;
        this.dizi = new TurkceHarf[this.boy];
        System.arraycopy(inpDizi, 0, this.dizi, 0, this.boy);
    }

    public void sil() {
        this.boy = 0;
    }

    public TurkceHarf sonHarf() {
        if (this.boy > 0) {
            return this.dizi[this.boy - 1];
        }
        return Alfabe.TANIMSIZ_HARF;
    }

    public TurkceHarf sonSesli() {
        for (int i = this.boy - 1; i >= 0; --i) {
            if (!this.dizi[i].sesliMi()) continue;
            return this.dizi[i];
        }
        return Alfabe.TANIMSIZ_HARF;
    }

    private void kapasiteAyarla(int ek) {
        TurkceHarf[] yeniDizi = new TurkceHarf[this.dizi.length + ek];
        System.arraycopy(this.dizi, 0, yeniDizi, 0, this.dizi.length);
        this.dizi = yeniDizi;
    }

    private void kapasiteAyarla() {
        TurkceHarf[] yeniDizi = new TurkceHarf[this.dizi.length * 2];
        System.arraycopy(this.dizi, 0, yeniDizi, 0, this.dizi.length);
        this.dizi = yeniDizi;
    }

    public HarfDizisi ekle(TurkceHarf harf) {
        if (this.boy == this.dizi.length) {
            this.kapasiteAyarla(3);
        }
        this.dizi[this.boy++] = harf;
        return this;
    }

    public void ekle(int index, TurkceHarf harf) {
        if (index < 0 || index > this.boy) {
            throw new ArrayIndexOutOfBoundsException("index degeri:" + index + " fakat harf dizi boyu:" + this.boy);
        }
        if (this.boy == this.dizi.length) {
            this.kapasiteAyarla();
        }
        for (int i = this.boy - 1; i >= index; --i) {
            this.dizi[i + 1] = this.dizi[i];
        }
        this.dizi[index] = harf;
        ++this.boy;
    }

    public HarfDizisi ekle(HarfDizisi hdizi) {
        int hboy = hdizi.length();
        if (this.boy + hboy > this.dizi.length) {
            this.kapasiteAyarla(hboy);
        }
        System.arraycopy(hdizi.dizi, 0, this.dizi, this.boy, hboy);
        this.boy += hdizi.length();
        return this;
    }

    public HarfDizisi ekle(int index, HarfDizisi hdizi) {
        if (index < 0 || index > this.boy) {
            throw new ArrayIndexOutOfBoundsException("indeks degeri:" + index + " fakat harf dizi boyu:" + this.boy);
        }
        int hboy = hdizi.length();
        if (this.boy + hboy > this.dizi.length) {
            this.kapasiteAyarla(hboy);
        }
        for (int i = hboy + this.boy - 1; i >= hboy; --i) {
            this.dizi[i] = this.dizi[i - hboy];
        }
        System.arraycopy(hdizi.dizi, 0, this.dizi, index, hboy);
        this.boy += hdizi.length();
        return this;
    }

    public HarfDizisi araDizi(int bas, int son) {
        if (son < bas) {
            return null;
        }
        TurkceHarf[] yeniHarfler = new TurkceHarf[son - bas];
        System.arraycopy(this.dizi, bas, yeniHarfler, 0, son - bas);
        return new HarfDizisi(yeniHarfler);
    }

    public TurkceHarf harf(int i) {
        if (i < 0) {
            return Alfabe.TANIMSIZ_HARF;
        }
        if (i < this.boy) {
            return this.dizi[i];
        }
        return Alfabe.TANIMSIZ_HARF;
    }

    public TurkceHarf ilkSesli(int basla) {
        for (int i = basla; i < this.boy; ++i) {
            if (!this.dizi[i].sesliMi()) continue;
            return this.dizi[i];
        }
        return Alfabe.TANIMSIZ_HARF;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof HarfDizisi)) {
            return false;
        }
        HarfDizisi harfDizisi = (HarfDizisi)o;
        if (this.boy != harfDizisi.boy) {
            return false;
        }
        for (int i = 0; i < this.boy; ++i) {
            if (this.dizi[i].charDeger() == harfDizisi.dizi[i].charDeger()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean asciiToleransliKiyasla(HarfDizisi harfDizisi) {
        if (harfDizisi == null) {
            return false;
        }
        if (this == harfDizisi) {
            return true;
        }
        if (this.boy != harfDizisi.boy) {
            return false;
        }
        for (int i = 0; i < this.boy; ++i) {
            if (this.dizi[i].asciiToleransliKiyasla(harfDizisi.dizi[i])) continue;
            return false;
        }
        return true;
    }

    public boolean asciiToleransliAradanKiyasla(int baslangic, HarfDizisi kelime) {
        if (kelime == null) {
            return false;
        }
        if (this.boy < baslangic + kelime.length()) {
            return false;
        }
        for (int i = 0; i < kelime.length(); ++i) {
            if (this.dizi[baslangic + i].asciiToleransliKiyasla(kelime.harf(i))) continue;
            return false;
        }
        return true;
    }

    public boolean asciiToleransliBastanKiyasla(HarfDizisi giris) {
        if (giris == null) {
            return false;
        }
        if (giris.length() > this.boy) {
            return false;
        }
        for (int i = 0; i < giris.length(); ++i) {
            if (this.dizi[i].asciiToleransliKiyasla(giris.harf(i))) continue;
            return false;
        }
        return true;
    }

    public boolean aradanKiyasla(int baslangic, HarfDizisi kelime) {
        if (kelime == null) {
            return false;
        }
        if (this.boy < baslangic + kelime.length()) {
            return false;
        }
        for (int i = 0; i < kelime.length(); ++i) {
            if (this.dizi[baslangic + i].charDeger() == kelime.harf(i).charDeger()) continue;
            return false;
        }
        return true;
    }

    public boolean bastanKiyasla(HarfDizisi giris) {
        if (giris == null) {
            return false;
        }
        if (giris.length() > this.boy) {
            return false;
        }
        for (int i = 0; i < giris.length(); ++i) {
            if (this.dizi[i].charDeger() == giris.harf(i).charDeger()) continue;
            return false;
        }
        return true;
    }

    public void harfDegistir(int index, TurkceHarf harf) {
        if (index < 0 || index >= this.boy) {
            throw new ArrayIndexOutOfBoundsException("indeks degeri:" + index + " fakat harf dizi boyu:" + this.boy);
        }
        this.dizi[index] = harf;
    }

    public void sonHarfYumusat() {
        if (this.boy == 0) {
            return;
        }
        TurkceHarf yum = this.dizi[this.boy - 1].yumusama();
        if (yum != null) {
            this.dizi[this.boy - 1] = this.dizi[this.boy - 1].yumusama();
        }
    }

    public void sonHarfSil() {
        if (this.boy > 0) {
            --this.boy;
        }
    }

    public HarfDizisi harfSil(int index) {
        if (index < 0 || index >= this.boy) {
            throw new ArrayIndexOutOfBoundsException("indeks degeri:" + index + " fakat harf dizi boyu:" + this.boy);
        }
        if (index == this.boy - 1) {
            --this.boy;
        } else {
            System.arraycopy(this.dizi, index + 1, this.dizi, index, this.boy - index - 1);
            --this.boy;
        }
        return this;
    }

    public HarfDizisi harfSil(int index, int harfSayisi) {
        if (index < 0 || index >= this.boy) {
            throw new ArrayIndexOutOfBoundsException("indeks degeri:" + index + " fakat harf dizi boyu:" + this.boy);
        }
        if (index + harfSayisi > this.boy) {
            harfSayisi = this.boy - index;
        }
        for (int i = index + harfSayisi; i < this.boy; ++i) {
            this.dizi[i - harfSayisi] = this.dizi[i];
        }
        this.boy -= harfSayisi;
        return this;
    }

    public TurkceHarf ilkHarf() {
        if (this.boy == 0) {
            return Alfabe.TANIMSIZ_HARF;
        }
        return this.dizi[0];
    }

    public void kirp(int index) {
        if (index <= this.boy && index >= 0) {
            this.boy = index;
        }
    }

    public String toString(int index) {
        if (index < 0 || index >= this.boy) {
            return "";
        }
        StringBuilder s = new StringBuilder(this.boy - index);
        for (int i = index; i < this.boy; ++i) {
            s.append(this.charAt(i));
        }
        return s.toString();
    }

    @Override
    public String toString() {
        return new StringBuilder(this).toString();
    }

    @Override
    public int compareTo(HarfDizisi o) {
        if (o == null) {
            return 1;
        }
        if (this == o) {
            return 0;
        }
        int l = o.boy;
        int n = Math.min(this.boy, l);
        for (int i = 0; i < n; ++i) {
            if (this.dizi[i].equals(o.dizi[i])) continue;
            return this.dizi[i].alfabetikSira() - o.dizi[i].alfabetikSira();
        }
        return this.boy - l;
    }

    public int sesliSayisi() {
        int sonuc = 0;
        for (int i = 0; i < this.boy; ++i) {
            if (!this.dizi[i].sesliMi()) continue;
            ++sonuc;
        }
        return sonuc;
    }

    public boolean hepsiBuyukHarfmi() {
        for (int i = 0; i < this.boy; ++i) {
            if (this.dizi[i].buyukHarfMi()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int length() {
        return this.boy;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.boy) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.dizi[index].charDeger();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.araDizi(start, end);
    }
}

