/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.yapi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.zemberek.araclar.Kayitci;
import net.zemberek.bilgi.KaynakYukleyici;
import net.zemberek.yapi.TurkceHarf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alfabe {
    public static final char CHAR_CC = '\u00c7';
    public static final char CHAR_cc = '\u00e7';
    public static final char CHAR_GG = '\u011e';
    public static final char CHAR_gg = '\u011f';
    public static final char CHAR_ii = '\u0131';
    public static final char CHAR_II = '\u0130';
    public static final char CHAR_OO = '\u00d6';
    public static final char CHAR_oo = '\u00f6';
    public static final char CHAR_SS = '\u015e';
    public static final char CHAR_ss = '\u015f';
    public static final char CHAR_UU = '\u00dc';
    public static final char CHAR_uu = '\u00fc';
    public static final char CHAR_ee = '\u0259';
    public static final char CHAR_EE = '\u018f';
    public static final char CHAR_AA = '\u00c4';
    public static final char CHAR_aa = '\u00e4';
    public static final char CHAR_NN = '\u0147';
    public static final char CHAR_nn = '\u0148';
    public static final char CHAR_YY = '\u00dd';
    public static final char CHAR_yy = '\u00fd';
    public static final char CHAR_JJ = '\u017d';
    public static final char CHAR_jj = '\u017e';
    public static final char CHAR_SAPKALI_A = '\u00c2';
    public static final char CHAR_SAPKALI_a = '\u00e2';
    public static final char CHAR_SAPKALI_I = '\u00ce';
    public static final char CHAR_SAPKALI_i = '\u00ee';
    public static final char CHAR_SAPKALI_U = '\u00db';
    public static final char CHAR_SAPKALI_u = '\u00fb';
    public static final char CHAR_TT_n = '\u00f1';
    public static final char CHAR_TT_N = '\u00d1';
    public static final TurkceHarf TANIMSIZ_HARF = new TurkceHarf('#', 0);
    public static final char ALFABE_DISI_KARAKTER = '#';
    protected static final int TURKISH_CHAR_MAP_SIZE = 610;
    protected static final int TURKISH_HARF_MAP_SIZE = 50;
    protected char[] temizlemeDizisi = new char[610];
    protected char[] asciifierDizisi = new char[610];
    protected TurkceHarf[] turkceHarfDizisi = new TurkceHarf[610];
    protected TurkceHarf[] kucukHarflerDizi = new TurkceHarf[50];
    protected TurkceHarf[] buyukHarflerDizi = new TurkceHarf[50];
    protected boolean[] turkceMap = new boolean[610];
    protected byte[] alfabetikSiralar = new byte[610];
    protected Map<Character, TurkceHarf> harfler = new HashMap<Character, TurkceHarf>();
    private char[] asciiDisi = new char[20];
    private Map<TurkceHarf, TurkceHarf> ozelInceSesliler = new HashMap<TurkceHarf, TurkceHarf>();
    private static Logger logger = Kayitci.kayitciUret(Alfabe.class);
    protected Locale locale;
    private final Pattern virgulReg = Pattern.compile("[,]");
    private final Pattern tireReg = Pattern.compile("[-]");
    public static final String HARFLER = "harfler";
    public static final String SESLI = "sesli";
    public static final String INCE_SESLI = "ince-sesli";
    public static final String DUZ_SESLI = "duz-sesli";
    public static final String YUVARLAK_SESLI = "yuvarlak-sesli";
    public static final String SERT = "sert";
    public static final String ASCII_DISI = "ascii-disi";
    public static final String ASCII_TURKCE = "ascii-turkce";
    public static final String TURKCE_ASCII = "turkce-ascii";
    public static final String YUMUSAMA_DONUSUM = "yumusama-donusum";
    public static final String SERT_DONUSUM = "sert-donusum";
    public static final String AYIKLAMA = "ayiklama";
    public static final String AYIKLAMA_DONUSUM = "ayiklama-donusum";
    public static final String OZEL_INCE_SESLI = "ozel-ince-sesli";
    public static final String LOCALE = "locale";

    public Alfabe(String dosyaAdi, String localeStr) throws IOException {
        Map<String, String> harfOzellikleri = new KaynakYukleyici("UTF-8").kodlamaliOzellikDosyasiOku(dosyaAdi);
        this.locale = new Locale(localeStr);
        this.diziInit();
        this.harfBilgisiOlustur(harfOzellikleri);
    }

    private void diziInit() {
        for (int i = 0; i < 610; ++i) {
            this.temizlemeDizisi[i] = 35;
            this.turkceMap[i] = false;
            this.asciifierDizisi[i] = (char)i;
        }
    }

    public TurkceHarf harf(char harf) {
        if (harf > '\u0262') {
            return TANIMSIZ_HARF;
        }
        return this.turkceHarfDizisi[harf];
    }

    public String ayikla(String giris) {
        StringBuilder buf = new StringBuilder(giris.length());
        for (int i = 0; i < giris.length(); ++i) {
            char temiz;
            if (giris.charAt(i) >= '\u0262' || (temiz = this.temizlemeDizisi[giris.charAt(i)]) == '#') continue;
            buf.append(temiz);
        }
        return buf.toString();
    }

    public boolean cozumlemeyeUygunMu(String giris) {
        for (int i = 0; i < giris.length(); ++i) {
            if (this.turkceMap[giris.charAt(i)] && giris.charAt(i) <= '\u0262') continue;
            return false;
        }
        return true;
    }

    public String asciifyString(String in) {
        char[] buffer = in.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.asciifierDizisi[buffer[i]];
        }
        return new String(buffer);
    }

    public TurkceHarf buyukHarf(TurkceHarf harf) {
        TurkceHarf buyuk = this.buyukHarflerDizi[harf.alfabetikSira() - 1];
        if (buyuk != null) {
            return buyuk;
        }
        return TANIMSIZ_HARF;
    }

    public TurkceHarf buyukHarf(char c) {
        TurkceHarf buyuk = this.buyukHarflerDizi[this.harf(c).alfabetikSira() - 1];
        if (buyuk != null) {
            return buyuk;
        }
        return TANIMSIZ_HARF;
    }

    public TurkceHarf kucukHarf(TurkceHarf harf) {
        TurkceHarf kucuk = this.kucukHarflerDizi[harf.alfabetikSira() - 1];
        if (kucuk != null) {
            return kucuk;
        }
        return TANIMSIZ_HARF;
    }

    public boolean asciiToleransliKiyasla(char harf1, char harf2) {
        if (harf1 > '\u0262' || harf2 > '\u0262') {
            return false;
        }
        return this.asciifierDizisi[harf1] == this.asciifierDizisi[harf2];
    }

    public char[] asciiDisiHarfler() {
        return this.asciiDisi;
    }

    public TurkceHarf kalinSesliIncelt(TurkceHarf kalinSesli) {
        if (this.ozelInceSesliler.containsKey(kalinSesli)) {
            return this.ozelInceSesliler.get(kalinSesli);
        }
        return kalinSesli;
    }

    private void harfBilgisiOlustur(Map<String, String> bilgi) {
        TurkceHarf harf;
        char c;
        int i;
        String lcl;
        Locale loc = this.locale;
        if (bilgi.containsKey(LOCALE) && (lcl = this.ozellik(bilgi, LOCALE)) != null && lcl.length() > 0) {
            loc = new Locale(lcl);
        }
        String tumKucukler = this.ozellik(bilgi, HARFLER);
        String tumBuyukler = tumKucukler.toUpperCase(loc);
        char[] kucukler = this.harfAyristir(tumKucukler);
        char[] buyukler = this.harfAyristir(tumBuyukler);
        for (i = 0; i < kucukler.length; ++i) {
            c = kucukler[i];
            harf = new TurkceHarf(c);
            harf.setAlfabetikSira(i + 1);
            this.harfler.put(Character.valueOf(c), harf);
            this.turkceHarfDizisi[c] = harf;
            this.kucukHarflerDizi[i] = harf;
            this.temizlemeDizisi[c] = c;
            this.turkceMap[c] = true;
            this.asciifierDizisi[c] = c;
        }
        for (i = 0; i < buyukler.length; ++i) {
            c = buyukler[i];
            harf = new TurkceHarf(c);
            if (Character.isLetter(c)) {
                harf.setBuyukHarf(true);
            }
            harf.setAlfabetikSira(i + 1);
            this.harfler.put(Character.valueOf(c), harf);
            this.buyukHarflerDizi[i] = harf;
            this.temizlemeDizisi[c] = this.kucukHarflerDizi[i].charDeger();
            this.turkceHarfDizisi[c] = harf;
        }
        for (char c2 : this.harfAyristir(this.ozellik(bilgi, SESLI))) {
            this.harf(c2).setSesli(true);
            this.buyukHarf(this.mapHarf(c2)).setSesli(true);
        }
        for (char c2 : this.harfAyristir(this.ozellik(bilgi, INCE_SESLI))) {
            this.harf(c2).setInceSesli(true);
            this.buyukHarf(c2).setInceSesli(true);
        }
        for (char c2 : this.harfAyristir(this.ozellik(bilgi, DUZ_SESLI))) {
            this.harf(c2).setDuzSesli(true);
            this.buyukHarf(c2).setDuzSesli(true);
        }
        for (char c2 : this.harfAyristir(this.ozellik(bilgi, YUVARLAK_SESLI))) {
            this.harf(c2).setYuvarlakSesli(true);
            this.buyukHarf(c2).setYuvarlakSesli(true);
        }
        for (char c2 : this.harfAyristir(this.ozellik(bilgi, SERT))) {
            this.harf(c2).setSert(true);
            this.buyukHarf(c2).setSert(true);
        }
        this.asciiDisi = this.harfAyristir(this.ozellik(bilgi, ASCII_DISI));
        for (char c2 : this.asciiDisi) {
            this.harf(c2).setAsciiDisi(true);
        }
        for (char c2 : this.harfAyristir(this.ozellik(bilgi, AYIKLAMA))) {
            this.temizlemeDizisi[c2] = 35;
            this.temizlemeDizisi[this.buyukHarf((char)c2).charDeger()] = 35;
        }
        for (HarfCifti cift : this.harfCiftiAyristir(this.ozellik(bilgi, AYIKLAMA_DONUSUM))) {
            this.temizlemeDizisi[cift.h1] = cift.h2;
            this.temizlemeDizisi[this.buyukHarf((char)cift.h1).charDeger()] = this.buyukHarf(cift.h2).charDeger();
        }
        List<HarfCifti> yumusamaDonusum = this.harfCiftiAyristir(this.ozellik(bilgi, YUMUSAMA_DONUSUM));
        for (HarfCifti cift : yumusamaDonusum) {
            this.harf(cift.h1).setYumusama(this.harf(cift.h2));
            this.buyukHarf(cift.h1).setYumusama(this.buyukHarf(cift.h2));
        }
        if (bilgi.containsKey(SERT_DONUSUM)) {
            for (HarfCifti cift : this.harfCiftiAyristir(this.ozellik(bilgi, SERT_DONUSUM))) {
                this.harf(cift.h1).setSertDonusum(this.harf(cift.h2));
                this.buyukHarf(cift.h1).setSertDonusum(this.buyukHarf(cift.h2));
            }
        } else {
            for (HarfCifti cift : yumusamaDonusum) {
                this.harf(cift.h2).setSertDonusum(this.harf(cift.h1));
                this.buyukHarf(cift.h2).setSertDonusum(this.buyukHarf(cift.h1));
            }
        }
        List<HarfCifti> asciiDonusum = this.harfCiftiAyristir(this.ozellik(bilgi, TURKCE_ASCII));
        for (HarfCifti cift : asciiDonusum) {
            this.asciifierDizisi[cift.h1] = cift.h2;
            this.mapHarf(cift.h1).setAsciiDonusum(this.harfler.get(Character.valueOf(cift.h2)));
        }
        if (bilgi.containsKey(ASCII_TURKCE)) {
            for (HarfCifti cift : this.harfCiftiAyristir(this.ozellik(bilgi, ASCII_TURKCE))) {
                this.mapHarf(cift.h1).setTurkceDonusum(this.harfler.get(Character.valueOf(cift.h2)));
            }
        } else {
            for (HarfCifti cift : asciiDonusum) {
                this.harf(cift.h2).setTurkceDonusum(this.harf(cift.h1));
            }
        }
        if (bilgi.containsKey(OZEL_INCE_SESLI)) {
            for (char c3 : this.harfAyristir(this.ozellik(bilgi, OZEL_INCE_SESLI))) {
                TurkceHarf inceltilmisKalinSesli = this.harf(c3).clone();
                inceltilmisKalinSesli.setInceSesli(true);
                this.ozelInceSesliler.put(this.harf(c3), inceltilmisKalinSesli);
            }
        }
    }

    protected String ozellik(Map<String, String> harfOzellikleri, String anahtar) {
        if (harfOzellikleri.containsKey(anahtar)) {
            return harfOzellikleri.get(anahtar);
        }
        logger.warning("harf ozelligi bulunamiyor: " + anahtar);
        return "";
    }

    private TurkceHarf mapHarf(char c) {
        if (!this.harfler.containsKey(Character.valueOf(c))) {
            throw new RuntimeException(c + " icin Turkce Harf Bulunamiyor!");
        }
        return this.harfler.get(Character.valueOf(c));
    }

    protected char[] harfAyristir(String tum) {
        tum = tum.replaceAll("[ \t]", "");
        String[] charStrDizi = this.virgulReg.split(tum);
        char[] cDizi = new char[charStrDizi.length];
        for (int i = 0; i < charStrDizi.length; ++i) {
            if (charStrDizi[i].length() != 1) {
                logger.warning(tum + "ayristirilirken tek harf bekleniyordu. " + charStrDizi + " uygun degil");
            }
            cDizi[i] = charStrDizi[i].charAt(0);
        }
        return cDizi;
    }

    protected List<HarfCifti> harfCiftiAyristir(String tum) {
        tum = tum.replaceAll("[ \t]", "");
        String[] charStrDizi = this.virgulReg.split(tum);
        ArrayList<HarfCifti> ciftler = new ArrayList<HarfCifti>(charStrDizi.length);
        for (String s : charStrDizi) {
            String[] cift = this.tireReg.split(s);
            if (cift.length != 2) {
                logger.warning(tum + "ayristirilirken harf cifti  bekleniyordu. " + s + " uygun degil.");
            }
            if (cift[0].length() != 1 || cift[1].length() != 1) {
                logger.warning(tum + "ayristirilirken tek harf bekleniyordu. " + charStrDizi + " uygun degil");
            }
            char h1 = cift[0].charAt(0);
            char h2 = cift[1].charAt(0);
            ciftler.add(new HarfCifti(h1, h2));
        }
        return ciftler;
    }

    protected class HarfCifti {
        final char h1;
        final char h2;

        public HarfCifti(char h1, char h2) {
            this.h1 = h1;
            this.h2 = h2;
        }
    }
}

