/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.istatistik;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.zemberek.araclar.IstatistikAraclari;
import net.zemberek.istatistik.EkZinciri;
import net.zemberek.istatistik.GenelKokIstatistikBilgisi;
import net.zemberek.istatistik.Istatistik;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.Kok;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KokIstatistikleri
implements Istatistik {
    private static HashMap<String, GenelKokIstatistikBilgisi> kokler = new HashMap(100);
    private long toplamKelime = 0L;
    private long toplamIsimKokSayisi = 0L;
    private long toplamSifatKokSayisi = 0L;
    private long toplamFiilKokSayisi = 0L;
    private long toplamSayiKokSayisi = 0L;
    private long toplamIsimSayisi = 0L;
    private long toplamSifatSayisi = 0L;
    private long toplamFiilSayisi = 0L;
    private long toplamSayiSayisi = 0L;
    private long toplamKelimeUzunlugu = 0L;
    private long toplamIsimKelimeUzunlugu = 0L;
    private long toplamSifatKelimeUzunlugu = 0L;
    private long toplamFiilKelimeUzunlugu = 0L;
    private long toplamSayiKelimeUzunlugu = 0L;
    private double ortalamaKelimeUzunlugu = 0.0;
    private double ortalamaIsimKokUzunlugu = 0.0;
    private double ortalamaFiilKokUzunlugu = 0.0;
    private double ortalamaKokUzunlugu = 0.0;
    private double ortalamaIsimUzunlugu = 0.0;
    private double ortalamaFiilUzunlugu = 0.0;
    private long toplamKokSayisi = 0L;
    private long toplamKelimeSayisi = 0L;
    private int[] kontrolDizisi = new int[]{2, 5, 10, 20, 50, 100, 250, 500, 750, 1000, 1500, 2000, 3000, 5000, 7500, 10000, 15000, 20000};
    private long[] araToplamlar = new long[this.kontrolDizisi.length];
    private int araToplamSayaci = 0;
    private int[] toplamEkUzunlukSayilari = new int[15];
    private double[] kokKapsamaYuzdeleri = new double[this.kontrolDizisi.length];
    private ArrayList<GenelKokIstatistikBilgisi> kokListesi = null;

    public void sonucGuncelle(Kok kok, Kelime giris) {
        GenelKokIstatistikBilgisi kokBilgisi = kokler.get(kok.icerik());
        if (kokBilgisi == null) {
            kokBilgisi = new GenelKokIstatistikBilgisi(kok);
            kokler.put(kok.icerik(), kokBilgisi);
        }
        if (kokBilgisi.getKok().tip() == KelimeTipi.ISIM) {
            ++this.toplamIsimSayisi;
            this.toplamIsimKelimeUzunlugu += (long)giris.icerik().length();
        } else if (kokBilgisi.getKok().tip() == KelimeTipi.FIIL) {
            ++this.toplamFiilSayisi;
            this.toplamFiilKelimeUzunlugu += (long)giris.icerik().length();
        } else if (kokBilgisi.getKok().tip() == KelimeTipi.SIFAT) {
            ++this.toplamSifatSayisi;
            this.toplamSifatKelimeUzunlugu += (long)giris.icerik().length();
        } else if (kokBilgisi.getKok().tip() == KelimeTipi.SAYI) {
            ++this.toplamSayiSayisi;
            this.toplamSayiKelimeUzunlugu += (long)giris.icerik().length();
        }
        kokBilgisi.guncelle(giris);
    }

    @Override
    public void tamamla() {
        GenelKokIstatistikBilgisi istatistik;
        int i;
        this.kokListesi = new ArrayList();
        this.araToplamSayaci = 0;
        for (GenelKokIstatistikBilgisi kokBilgisi : kokler.values()) {
            this.toplamKelime += kokBilgisi.getKullanimSayisi();
            if (kokBilgisi.getKok().tip() == KelimeTipi.ISIM) {
                ++this.toplamIsimKokSayisi;
            }
            if (kokBilgisi.getKok().tip() == KelimeTipi.FIIL) {
                ++this.toplamFiilKokSayisi;
            }
            if (kokBilgisi.getKok().tip() == KelimeTipi.SIFAT) {
                ++this.toplamSifatKokSayisi;
            }
            this.kokListesi.add(kokBilgisi);
        }
        Collections.sort(this.kokListesi, new KokMiktarKarsilastirici());
        long araToplam = 0L;
        for (i = 0; i < this.kokListesi.size(); ++i) {
            istatistik = this.kokListesi.get(i);
            istatistik.setKullanimFrekansi((int)((double)istatistik.getKullanimSayisi() / (double)this.toplamKelime * 1000000.0));
            araToplam += istatistik.getKullanimSayisi();
            if (i + 1 == this.kontrolDizisi[this.araToplamSayaci]) {
                this.araToplamlar[this.araToplamSayaci] = araToplam;
                ++this.araToplamSayaci;
            }
            int[] ekUzunlukSayilari = istatistik.getEkUzunlukSayilari();
            for (int j = 0; j < ekUzunlukSayilari.length; ++j) {
                int n = j;
                this.toplamEkUzunlukSayilari[n] = this.toplamEkUzunlukSayilari[n] + ekUzunlukSayilari[j];
            }
        }
        for (i = 0; i < this.araToplamSayaci; ++i) {
            this.kokKapsamaYuzdeleri[i] = IstatistikAraclari.yuzdeHesapla(this.araToplamlar[i], this.toplamKelime);
        }
        this.toplamKelimeSayisi = this.toplamKelime;
        this.toplamKokSayisi = this.kokListesi.size();
        this.ortalamaIsimUzunlugu = (double)this.toplamIsimKelimeUzunlugu / (double)this.toplamIsimSayisi;
        this.ortalamaFiilUzunlugu = (double)this.toplamFiilKelimeUzunlugu / (double)this.toplamFiilSayisi;
        i = 0;
        while ((long)i < this.toplamKokSayisi) {
            istatistik = this.kokListesi.get(i);
            istatistik.duzenle();
            List<EkZinciri> ekler = istatistik.getEkListesi();
            ++i;
        }
    }

    public long getToplamKelimeSayisi() {
        return this.toplamKelimeSayisi;
    }

    public List<GenelKokIstatistikBilgisi> getKokListesi() {
        return this.kokListesi;
    }

    public long getToplamKokSayisi() {
        return this.toplamKokSayisi;
    }

    public void setToplamKokSayisi(long toplamKokSayisi) {
        this.toplamKokSayisi = toplamKokSayisi;
    }

    public static HashMap<String, GenelKokIstatistikBilgisi> getKokler() {
        return kokler;
    }

    public long[] getAraToplamlar() {
        return this.araToplamlar;
    }

    public int getAraToplamSayaci() {
        return this.araToplamSayaci;
    }

    public double[] getKokKapsamaYuzdeleri() {
        return this.kokKapsamaYuzdeleri;
    }

    public int[] getKontrolDizisi() {
        return this.kontrolDizisi;
    }

    public double getOrtalamaFiilKokUzunlugu() {
        return this.ortalamaFiilKokUzunlugu;
    }

    public double getOrtalamaFiilUzunlugu() {
        return this.ortalamaFiilUzunlugu;
    }

    public double getOrtalamaIsimKokUzunlugu() {
        return this.ortalamaIsimKokUzunlugu;
    }

    public double getOrtalamaIsimUzunlugu() {
        return this.ortalamaIsimUzunlugu;
    }

    public double getOrtalamaKelimeUzunlugu() {
        return this.ortalamaKelimeUzunlugu;
    }

    public double getOrtalamaKokUzunlugu() {
        return this.ortalamaKokUzunlugu;
    }

    public int[] getToplamEkUzunlukSayilari() {
        return this.toplamEkUzunlukSayilari;
    }

    public long getToplamFiilKelimeUzunlugu() {
        return this.toplamFiilKelimeUzunlugu;
    }

    public long getToplamFiilKokSayisi() {
        return this.toplamFiilKokSayisi;
    }

    public long getToplamFiilSayisi() {
        return this.toplamFiilSayisi;
    }

    public long getToplamIsimKelimeUzunlugu() {
        return this.toplamIsimKelimeUzunlugu;
    }

    public long getToplamIsimKokSayisi() {
        return this.toplamIsimKokSayisi;
    }

    public long getToplamIsimSayisi() {
        return this.toplamIsimSayisi;
    }

    public long getToplamKelime() {
        return this.toplamKelime;
    }

    public long getToplamKelimeUzunlugu() {
        return this.toplamKelimeUzunlugu;
    }

    public long getToplamSayiKelimeUzunlugu() {
        return this.toplamSayiKelimeUzunlugu;
    }

    public long getToplamSayiKokSayisi() {
        return this.toplamSayiKokSayisi;
    }

    public long getToplamSayiSayisi() {
        return this.toplamSayiSayisi;
    }

    public long getToplamSifatKelimeUzunlugu() {
        return this.toplamSifatKelimeUzunlugu;
    }

    public long getToplamSifatKokSayisi() {
        return this.toplamSifatKokSayisi;
    }

    public long getToplamSifatSayisi() {
        return this.toplamSifatSayisi;
    }

    @Override
    public void guncelle() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KokMiktarKarsilastirici
    implements Comparator<GenelKokIstatistikBilgisi> {
        KokMiktarKarsilastirici() {
        }

        @Override
        public int compare(GenelKokIstatistikBilgisi o1, GenelKokIstatistikBilgisi o2) {
            return (int)(o2.getKullanimSayisi() - o1.getKullanimSayisi());
        }
    }
}

