/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.istatistik;

import java.util.ArrayList;
import java.util.List;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.ek.EkYonetici;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EkZinciri
implements Comparable<EkZinciri> {
    List<Ek> ekler = null;
    double kullanimFrekansi = 0.0;
    int kullanimSayisi;
    String eklerStr = "";

    public EkZinciri() {
        this.ekler = new ArrayList<Ek>();
    }

    public EkZinciri(List<Ek> ekler) {
        this.ekler = ekler;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < ekler.size(); ++i) {
            builder.append(ekler.get(i).ad());
            if (i >= ekler.size() - 1) continue;
            builder.append('+');
        }
        this.eklerStr = builder.toString();
        this.kullanimSayisi = 0;
        this.kullanimFrekansi = 0.0;
    }

    public EkZinciri(EkYonetici ekYonetici, String eklerStrRep, double oran) {
        String[] parsedEkler = eklerStrRep.trim().split(" ");
        for (int i = 0; i < parsedEkler.length; ++i) {
            Ek ek = ekYonetici.ek(parsedEkler[i]);
            if (ek != null) {
                if (this.ekler == null) {
                    this.ekler = new ArrayList<Ek>(2);
                }
                this.ekler.add(ek);
            }
            this.eklerStr = this.eklerStr + parsedEkler[i];
        }
        this.kullanimFrekansi = oran;
    }

    @Override
    public int compareTo(EkZinciri o) {
        EkZinciri giris = o;
        return giris.kullanimFrekansi - this.kullanimFrekansi > 0.0 ? 1 : -1;
    }

    public String getStringRep() {
        return this.eklerStr;
    }

    public String toString() {
        return this.eklerStr;
    }

    public String getEklerStr() {
        return this.eklerStr;
    }

    public List<Ek> getEkler() {
        return this.ekler;
    }

    public void ekEkle(Ek ek) {
        this.ekler.add(ek);
    }

    public double getKullanimFrekansi() {
        return this.kullanimFrekansi;
    }

    public int getKullanimSayisi() {
        return this.kullanimSayisi;
    }
}

