/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.islemler.cozumleme;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.zemberek.araclar.MetinAraclari;
import net.zemberek.bilgi.kokler.KokAdayiBulucu;
import net.zemberek.islemler.cozumleme.BasitKelimeYigini;
import net.zemberek.islemler.cozumleme.CozumlemeYardimcisi;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.HarfDizisi;
import net.zemberek.yapi.Kelime;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.ek.Ek;
import net.zemberek.yapi.ek.EkYonetici;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToleransliCozumleyici {
    public static final Kelime[] BOS_KELIME_DIZISI = new Kelime[0];
    public static final int TOLERANS = 1;
    private static Logger log = Logger.getLogger("ToleransliCozumleyici.class");
    private KokAdayiBulucu kokBulucu;
    private EkYonetici ekYonetici;
    private Alfabe alfabe;
    private CozumlemeYardimcisi yardimci;

    public ToleransliCozumleyici(KokAdayiBulucu kokBulucu, EkYonetici yonetici, Alfabe alfabe, CozumlemeYardimcisi yardimci) {
        this.kokBulucu = kokBulucu;
        this.ekYonetici = yonetici;
        this.alfabe = alfabe;
        this.yardimci = yardimci;
    }

    public Kelime[] cozumle(String strGiris) {
        String strIslenmis = this.alfabe.ayikla(strGiris);
        if (strIslenmis.length() == 0) {
            return BOS_KELIME_DIZISI;
        }
        List<Kok> kokler = this.kokBulucu.adayKokleriBul(strIslenmis);
        ArrayList<Kelime> cozumler = new ArrayList<Kelime>();
        if (log.isLoggable(Level.FINER)) {
            log.finer("Giris: " + strIslenmis + ", Adaylar: " + kokler);
        }
        HarfDizisi girisDizi = new HarfDizisi(strIslenmis, this.alfabe);
        boolean icerikDegisti = false;
        for (int i = kokler.size() - 1; i >= 0; --i) {
            Kok kok = kokler.get(i);
            HarfDizisi kokDizi = new HarfDizisi(kok.icerik(), this.alfabe);
            if (icerikDegisti) {
                girisDizi = new HarfDizisi(strIslenmis, this.alfabe);
            }
            int kokHatasi = 0;
            icerikDegisti = this.yardimci.kokGirisDegismiVarsaUygula(kok, kokDizi, girisDizi);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Aday:" + kok.icerik() + " tolerans:" + kokHatasi);
            }
            if (MetinAraclari.duzeltmeMesafesiIcinde(kok.icerik(), strIslenmis, 1)) {
                cozumler.add(new Kelime(kok, this.alfabe));
            }
            List<Kelime> sonuclar = 1 > kokHatasi ? this.coz(kok, kokDizi, girisDizi, 1 - kokHatasi) : this.coz(kok, kokDizi, girisDizi, 0);
            cozumler.addAll(sonuclar);
        }
        for (Kelime kel : cozumler) {
            this.yardimci.kelimeBicimlendir(kel);
            if (!Character.isUpperCase(strGiris.charAt(0))) continue;
            kel.icerik().harfDegistir(0, this.alfabe.buyukHarf(kel.icerik().ilkHarf()));
        }
        return cozumler.toArray(new Kelime[cozumler.size()]);
    }

    private List<Kelime> coz(Kok kok, HarfDizisi kokDizi, HarfDizisi girisDizi, int tolerans) {
        Kelime kelime = new Kelime(kok, kokDizi);
        kelime.ekEkle(this.ekYonetici.ilkEkBelirle(kelime.kok()));
        BasitKelimeYigini kelimeYigini = new BasitKelimeYigini();
        ArrayList<Kelime> uygunSonuclar = new ArrayList<Kelime>();
        kelimeYigini.temizle();
        Ek bulunanEk = kelime.sonEk();
        int ardisilEkSirasi = 0;
        while (true) {
            Ek incelenenEk;
            if ((incelenenEk = bulunanEk.getArdisilEk(ardisilEkSirasi++)) == null) {
                if (kelimeYigini.bosMu()) {
                    return uygunSonuclar;
                }
                BasitKelimeYigini.YiginKelime yiginKelime = kelimeYigini.al();
                kelime = yiginKelime.getKelime();
                bulunanEk = kelime.sonEk();
                ardisilEkSirasi = yiginKelime.getEkSirasi();
                continue;
            }
            if (kelime.ekler().size() == 1 && kelime.kok().ozelDurumVarmi() && !this.ozelDurumDenetle(kelime, girisDizi, incelenenEk, tolerans)) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Ozel durum yanlis, ek:" + incelenenEk);
                continue;
            }
            HarfDizisi olusanEk = incelenenEk.cozumlemeIcinUret(kelime, girisDizi, null);
            if (olusanEk == null || olusanEk.length() == 0) continue;
            if (log.isLoggable(Level.FINER)) {
                log.finest("Kok ve Olusan Ek:" + kelime.icerik() + " " + olusanEk);
            }
            HarfDizisi olusum = new HarfDizisi(kelime.icerik());
            olusum.ekle(olusanEk);
            String olusumStr = olusum.toString();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("olusum:" + olusum);
            }
            if (!MetinAraclari.duzeltmeMesafesiIcinde(olusumStr, girisDizi.toString(), tolerans) && !MetinAraclari.parcasiDuzeltmeMesafesiIcinde(olusumStr, girisDizi.toString(), tolerans)) continue;
            kelimeYigini.koy(kelime.clone(), ardisilEkSirasi);
            ardisilEkSirasi = 0;
            if (olusanEk.harf(0).sesliMi() && kelime.sonHarf().sertMi() && kelime.ekler().size() > 1 && olusanEk.ilkHarf().sertDonusum() != null) {
                kelime.icerik().sonHarfYumusat();
            }
            kelime.icerikEkle(olusanEk);
            kelime.ekEkle(incelenenEk);
            olusumStr = kelime.icerikStr();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("ekleme sonrasi olusan kelime: " + kelime.icerik());
            }
            bulunanEk = incelenenEk;
            if (!MetinAraclari.duzeltmeMesafesiIcinde(olusumStr, girisDizi.toString(), tolerans)) continue;
            uygunSonuclar.add(kelime.clone());
            if (!log.isLoggable(Level.FINER)) continue;
            log.finer("uygun kelime:" + kelime.icerik());
        }
    }

    private boolean ozelDurumDenetle(Kelime kelime, HarfDizisi girisDizi, Ek ek, int tolerans) {
        if (!kelime.kok().yapiBozucuOzelDurumVarmi()) {
            return true;
        }
        HarfDizisi testKokIcerigi = kelime.kok().ozelDurumUygula(this.alfabe, ek);
        if (testKokIcerigi == null) {
            return false;
        }
        if (MetinAraclari.parcasiDuzeltmeMesafesiIcinde(testKokIcerigi.toString(), girisDizi.toString(), tolerans)) {
            kelime.setIcerik(new HarfDizisi(testKokIcerigi));
            return true;
        }
        kelime.setIcerik(new HarfDizisi(kelime.kok().icerik(), this.alfabe));
        return false;
    }
}

