/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.islemler.cozumleme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.zemberek.bilgi.ZemberekAyarlari;
import net.zemberek.islemler.KelimeKokFrekansKiyaslayici;
import net.zemberek.islemler.cozumleme.CozumlemeSeviyesi;
import net.zemberek.islemler.cozumleme.CozumlemeYardimcisi;
import net.zemberek.islemler.cozumleme.KelimeCozumleyici;
import net.zemberek.islemler.cozumleme.ToleransliCozumleyici;
import net.zemberek.yapi.Kelime;

public class OneriUretici {
    private KelimeCozumleyici cozumleyici;
    private KelimeCozumleyici asciiToleransliCozumleyici;
    private ToleransliCozumleyici toleransliCozumleyici;
    private CozumlemeYardimcisi yardimci;
    private ZemberekAyarlari ayarlar;

    public OneriUretici(CozumlemeYardimcisi yardimci, KelimeCozumleyici cozumleyici, KelimeCozumleyici asciiToleransliCozumleyici, ToleransliCozumleyici toleransliCozumleyici, ZemberekAyarlari ayarlar) {
        this.yardimci = yardimci;
        this.toleransliCozumleyici = toleransliCozumleyici;
        this.cozumleyici = cozumleyici;
        this.asciiToleransliCozumleyici = asciiToleransliCozumleyici;
        this.ayarlar = ayarlar;
    }

    public String[] oner(String kelime) {
        Kelime[] oneriler = this.toleransliCozumleyici.cozumle(kelime);
        Kelime[] asciiTurkceOneriler = new Kelime[]{};
        if (this.ayarlar.oneriDeasciifierKullan()) {
            asciiTurkceOneriler = this.asciiToleransliCozumleyici.cozumle(kelime, CozumlemeSeviyesi.TUM_KOKLER);
        }
        Set<String> ayriYazimOnerileri = Collections.emptySet();
        if (this.ayarlar.oneriBilesikKelimeKullan()) {
            for (int i = 1; i < kelime.length(); ++i) {
                Kelime[] kelimeler2;
                Kelime[] kelimeler1;
                String s1 = kelime.substring(0, i);
                String s2 = kelime.substring(i, kelime.length());
                if (!this.cozumleyici.cozumlenebilir(s1) || !this.cozumleyici.cozumlenebilir(s2)) continue;
                HashSet<String> set1 = new HashSet<String>();
                for (Kelime kelime1 : kelimeler1 = this.cozumleyici.cozumle(s1, CozumlemeSeviyesi.TUM_KOKLER)) {
                    this.yardimci.kelimeBicimlendir(kelime1);
                    set1.add(kelime1.icerik().toString());
                }
                HashSet<String> set2 = new HashSet<String>();
                for (Kelime kelime1 : kelimeler2 = this.cozumleyici.cozumle(s2, CozumlemeSeviyesi.TUM_KOKLER)) {
                    this.yardimci.kelimeBicimlendir(kelime1);
                    set2.add(kelime1.icerik().toString());
                }
                if (ayriYazimOnerileri.size() == 0) {
                    ayriYazimOnerileri = new HashSet<String>();
                }
                for (String str1 : set1) {
                    for (String str2 : set2) {
                        ayriYazimOnerileri.add(str1 + " " + str2);
                    }
                }
            }
        }
        if (oneriler.length == 0 && ayriYazimOnerileri.size() == 0 && asciiTurkceOneriler.length == 0) {
            return new String[0];
        }
        ArrayList<Kelime> oneriList = new ArrayList<Kelime>();
        oneriList.addAll(Arrays.asList(oneriler));
        oneriList.addAll(Arrays.asList(asciiTurkceOneriler));
        Collections.sort(oneriList, new KelimeKokFrekansKiyaslayici());
        ArrayList<String> sonucListesi = new ArrayList<String>();
        for (Kelime anOneriList : oneriList) {
            sonucListesi.add(anOneriList.icerik().toString());
        }
        ArrayList<String> tekilListe = new ArrayList<String>(new LinkedHashSet(sonucListesi));
        for (String oneri : ayriYazimOnerileri) {
            if (tekilListe.size() >= this.ayarlar.getOneriMax()) break;
            tekilListe.add(oneri);
        }
        return tekilListe.toArray(new String[tekilListe.size()]);
    }
}

