/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi.kokler;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.zemberek.araclar.IstatistikAraclari;
import net.zemberek.araclar.TimeTracker;
import net.zemberek.bilgi.araclar.IkiliKokOkuyucu;
import net.zemberek.bilgi.kokler.AgacSozluk;
import net.zemberek.bilgi.kokler.KokDugumu;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.DilAyarlari;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.TurkceDilBilgisi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KokAgaciYuruyucu {
    int walkCount = 0;
    int distanceCalculationCount = 0;
    private AgacSozluk sozluk;
    int dugumSayisi = 0;
    int kokTasiyanDugumSayisi = 0;
    int esSesliTasiyanDugumSayisi = 0;
    int ucDugumSayisi = 0;
    int[] dugumSayilari = new int[50];
    Set<Kok> set;

    public KokAgaciYuruyucu(AgacSozluk sozluk, Set<Kok> set) {
        this.sozluk = sozluk;
        this.set = set;
    }

    public int getWalkCount() {
        return this.walkCount;
    }

    public void agaciTara() {
        this.yuru(this.sozluk.getAgac().getKokDugumu(), "");
    }

    public void yuru(KokDugumu dugum, String olusan) {
        KokDugumu[] altDugumler;
        String tester = (olusan + dugum.harf()).trim();
        ++this.walkCount;
        if (dugum != null) {
            ++this.dugumSayisi;
            if (dugum.kok() != null) {
                ++this.kokTasiyanDugumSayisi;
                if (this.set != null) {
                    this.set.add(dugum.kok());
                }
            }
            if (dugum.esSesliler() != null) {
                ++this.esSesliTasiyanDugumSayisi;
                if (this.set != null) {
                    this.set.addAll(dugum.esSesliler());
                }
            }
            if (!dugum.altDugumVarMi()) {
                ++this.ucDugumSayisi;
            } else {
                altDugumler = dugum.altDugumDizisi();
                int top = 0;
                for (KokDugumu altDugum : altDugumler) {
                    if (altDugum == null) continue;
                    ++top;
                }
                int n = top;
                this.dugumSayilari[n] = this.dugumSayilari[n] + 1;
            }
        }
        if ((altDugumler = dugum.altDugumDizisi()) != null) {
            for (KokDugumu altDugum : altDugumler) {
                if (altDugum == null) continue;
                this.yuru(altDugum, tester);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Toplam yurume sayisi (walks) " + this.walkCount + "\n");
        sb.append("Toplam Dugum Sayisi: " + this.dugumSayisi + "\n");
        sb.append("Kok tasiyan dugum sayisi: " + this.kokTasiyanDugumSayisi + "\n");
        sb.append("Es sesli tasiyan dugum sayisi: " + this.esSesliTasiyanDugumSayisi + "\n");
        sb.append("Alt dugumu olan dugum sayisi:" + (this.dugumSayisi - this.ucDugumSayisi) + "\n");
        sb.append("Alt dugumu olmayan (yaprak) dugum sayisi: " + this.ucDugumSayisi + "\n");
        sb.append("AltDugumu olanlar\u0131n d\u00f6k\u00fcm\u00fc: \n");
        int araToplam = 0;
        for (int i = 1; i < 30; ++i) {
            sb.append(i + " alt dugumu olanlar: " + this.dugumSayilari[i] + " Ara Toplam: " + (araToplam += this.dugumSayilari[i]) + " Yuzdesi: %" + IstatistikAraclari.yuzdeHesaplaStr(this.dugumSayilari[i], this.dugumSayisi - this.ucDugumSayisi) + " - Kaplam: " + IstatistikAraclari.yuzdeHesaplaStr(araToplam, this.dugumSayisi - this.ucDugumSayisi) + "\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> c = Class.forName("net.zemberek.tr.yapi.TurkiyeTurkcesi");
        TurkceDilBilgisi dilBilgisi = new TurkceDilBilgisi((DilAyarlari)c.newInstance());
        Alfabe alfabe = dilBilgisi.alfabe();
        AgacSozluk sozluk = null;
        TimeTracker.startClock("a");
        for (int i = 0; i < 10; ++i) {
            IkiliKokOkuyucu okuyucu = new IkiliKokOkuyucu("kaynaklar/tr/bilgi/kokler_tr.bin", dilBilgisi.kokOzelDurumlari());
            sozluk = new AgacSozluk(okuyucu, alfabe, dilBilgisi.kokOzelDurumlari());
            System.out.println(TimeTracker.getElapsedTimeString("a"));
        }
        KokAgaciYuruyucu yuruyucu = new KokAgaciYuruyucu(sozluk, new HashSet<Kok>());
        yuruyucu.agaciTara();
        System.out.println(yuruyucu);
    }
}

