/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi.kokler;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.zemberek.araclar.Kayitci;
import net.zemberek.bilgi.kokler.KokDugumu;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.Kok;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KokAgaci {
    private static Logger log = Kayitci.kayitciUret(KokAgaci.class);
    private KokDugumu baslangicDugumu = null;
    private int nodeCount = 0;
    private Alfabe alfabe;

    public KokAgaci(KokDugumu baslangicDugumu, Alfabe alfabe) {
        this.baslangicDugumu = baslangicDugumu;
        this.alfabe = alfabe;
    }

    public KokDugumu getKokDugumu() {
        return this.baslangicDugumu;
    }

    public Alfabe getAlfabe() {
        return this.alfabe;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void ekle(String icerik, Kok kok) {
        int idx;
        char[] giris = icerik.toCharArray();
        KokDugumu node = this.baslangicDugumu;
        KokDugumu oncekiDugum = null;
        for (idx = 0; idx < giris.length; ++idx) {
            oncekiDugum = node;
            if ((node = node.altDugumBul(giris[idx])) == null) break;
        }
        if (idx == giris.length) {
            if (node.altDugumVarMi()) {
                node.kokEkle(kok);
                node.setKelime(icerik);
            } else if (node.kelime().equals(icerik)) {
                node.kokEkle(kok);
            } else if (node.kok() != null) {
                KokDugumu newNode = node.dugumEkle(new KokDugumu(node.kelime().charAt(idx)));
                newNode.kopyala(node);
                node.temizle();
                node.kokEkle(kok);
                node.setKelime(icerik);
            }
            return;
        }
        if (oncekiDugum.kok() == null || idx == oncekiDugum.kelime().length()) {
            oncekiDugum.dugumEkle(new KokDugumu(giris[idx], icerik, kok));
            return;
        }
        if (oncekiDugum.kelime().equals(icerik)) {
            oncekiDugum.kokEkle(kok);
            return;
        }
        char[] nodeHd = ((String)oncekiDugum.kelime()).toCharArray();
        KokDugumu newNode = oncekiDugum;
        if (nodeHd.length <= giris.length) {
            while (idx < nodeHd.length && nodeHd[idx] == giris[idx]) {
                newNode = newNode.dugumEkle(new KokDugumu(nodeHd[idx]));
                ++idx;
            }
            if (idx < nodeHd.length) {
                KokDugumu temp = newNode.dugumEkle(new KokDugumu(nodeHd[idx]));
                temp.kopyala(oncekiDugum);
            } else {
                newNode.kopyala(oncekiDugum);
            }
            newNode.dugumEkle(new KokDugumu(giris[idx], icerik, kok));
            oncekiDugum.temizle();
        } else {
            while (idx < giris.length && giris[idx] == nodeHd[idx]) {
                newNode = newNode.dugumEkle(new KokDugumu(giris[idx]));
                ++idx;
            }
            if (idx < giris.length) {
                newNode.dugumEkle(new KokDugumu(giris[idx], icerik, kok));
            } else {
                newNode.kokEkle(kok);
                newNode.setKelime(icerik);
            }
            newNode = newNode.dugumEkle(new KokDugumu(nodeHd[idx]));
            newNode.kopyala(oncekiDugum);
            oncekiDugum.temizle();
        }
    }

    public List<Kok> bul(String str) {
        KokDugumu node;
        char[] girisChars = str.toCharArray();
        int girisIndex = 0;
        for (node = this.baslangicDugumu; !(node == null || girisIndex >= girisChars.length || node.kelime() != null && node.kelime().equals(str)); node = node.altDugumBul(girisChars[girisIndex++])) {
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Harf: " + node.harf() + " Taranan Kelime: " + node.kelime());
        }
        if (node != null) {
            return node.tumKokler(str);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.baslangicDugumu.toString();
    }
}

