/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi.kokler;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.zemberek.bilgi.araclar.KokOkuyucu;
import net.zemberek.bilgi.kokler.AsciiKokAdayiBulucu;
import net.zemberek.bilgi.kokler.KesinKokAdayiBulucu;
import net.zemberek.bilgi.kokler.KokAdayiBulucu;
import net.zemberek.bilgi.kokler.KokAdayiBulucuUretici;
import net.zemberek.bilgi.kokler.KokAgaci;
import net.zemberek.bilgi.kokler.KokAgaciYuruyucu;
import net.zemberek.bilgi.kokler.KokDugumu;
import net.zemberek.bilgi.kokler.Sozluk;
import net.zemberek.bilgi.kokler.ToleransliKokAdayiBulucu;
import net.zemberek.yapi.Alfabe;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.kok.KokOzelDurumBilgisi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgacSozluk
implements Sozluk {
    private KokAgaci agac = null;
    private AgacKokAdayiBulucuUretici kokAdayiBulucuFactory = null;
    private KokOzelDurumBilgisi ozelDurumlar;
    private int indeks = 0;

    public AgacSozluk(KokOkuyucu okuyucu, Alfabe alfabe, KokOzelDurumBilgisi ozelDurumlar) throws IOException {
        Kok kok;
        this.ozelDurumlar = ozelDurumlar;
        this.agac = new KokAgaci(new KokDugumu(), alfabe);
        while ((kok = okuyucu.oku()) != null) {
            this.ekle(kok);
        }
        this.kokAdayiBulucuFactory = new AgacKokAdayiBulucuUretici(this.agac);
    }

    public AgacSozluk(List<Kok> kokler, Alfabe alfabe, KokOzelDurumBilgisi ozelDurumlar) {
        this.agac = new KokAgaci(new KokDugumu(), alfabe);
        this.ozelDurumlar = ozelDurumlar;
        for (Kok kok : kokler) {
            this.ekle(kok);
        }
        this.kokAdayiBulucuFactory = new AgacKokAdayiBulucuUretici(this.agac);
    }

    @Override
    public List<Kok> kokBul(String str) {
        return this.agac.bul(str);
    }

    @Override
    public Kok kokBul(String str, KelimeTipi tip) {
        List<Kok> kokler = this.agac.bul(str);
        for (Kok kok : kokler) {
            if (kok.tip() != tip) continue;
            return kok;
        }
        return null;
    }

    @Override
    public Collection<Kok> tumKokler() {
        HashSet<Kok> set = new HashSet<Kok>(100);
        KokAgaciYuruyucu yuruyucu = new KokAgaciYuruyucu(this, set);
        yuruyucu.agaciTara();
        return set;
    }

    @Override
    public void ekle(Kok kok) {
        kok.setIndeks(this.indeks++);
        this.agac.ekle(kok.icerik(), kok);
        String[] degismisIcerikler = this.ozelDurumlar.ozelDurumUygula(kok);
        if (degismisIcerikler.length > 0) {
            for (String degismisIcerik : degismisIcerikler) {
                this.agac.ekle(degismisIcerik, kok);
            }
        }
    }

    public KokAgaci getAgac() {
        return this.agac;
    }

    @Override
    public KokAdayiBulucuUretici kokBulucuFactory() {
        return this.kokAdayiBulucuFactory;
    }

    class AgacKokAdayiBulucuUretici
    implements KokAdayiBulucuUretici {
        KokAgaci agac = null;

        public AgacKokAdayiBulucuUretici(KokAgaci agac) {
            this.agac = agac;
        }

        public KokAdayiBulucu kesinKokBulucu() {
            return new KesinKokAdayiBulucu(this.agac);
        }

        public KokAdayiBulucu toleransliKokBulucu(int tolerans) {
            return new ToleransliKokAdayiBulucu(this.agac, tolerans);
        }

        public KokAdayiBulucu asciiKokBulucu() {
            return new AsciiKokAdayiBulucu(this.agac);
        }
    }
}

