/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi.araclar;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import net.zemberek.bilgi.araclar.KokYazici;
import net.zemberek.yapi.Kisaltma;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.kok.KokOzelDurumu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IkiliKokYazici
implements KokYazici {
    DataOutputStream dos;

    public IkiliKokYazici(String dosyaAdi) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(dosyaAdi);
        this.dos = new DataOutputStream(new BufferedOutputStream(fos));
    }

    @Override
    public void yaz(List<Kok> kokler) throws IOException {
        for (Kok kok : kokler) {
            this.dos.writeUTF(kok.icerik());
            if (kok.asil() != null) {
                this.dos.writeUTF(kok.asil());
            } else {
                this.dos.writeUTF("");
            }
            this.dos.write(kok.tip().getIndeks());
            if (kok instanceof Kisaltma) {
                this.dos.writeChar(((Kisaltma)kok).getKisaltmaSonSeslisi());
            } else {
                this.dos.writeChar(35);
            }
            KokOzelDurumu[] ozd = kok.ozelDurumDizisi();
            this.dos.write(ozd.length);
            for (KokOzelDurumu ozelDurum : ozd) {
                this.dos.write(ozelDurum.indeks());
            }
            this.dos.writeInt(kok.getFrekans());
        }
        this.dos.close();
    }
}

