/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi.araclar;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.zemberek.bilgi.KaynakYukleyici;
import net.zemberek.bilgi.araclar.KokOkuyucu;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.Kisaltma;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.kok.KokOzelDurumBilgisi;
import net.zemberek.yapi.kok.KokOzelDurumu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IkiliKokOkuyucu
implements KokOkuyucu {
    private DataInputStream dis;
    private KokOzelDurumBilgisi ozelDurumlar;

    public IkiliKokOkuyucu(InputStream is, KokOzelDurumBilgisi ozelDurumlar) {
        this.dis = new DataInputStream(new BufferedInputStream(is));
        this.ozelDurumlar = ozelDurumlar;
    }

    public IkiliKokOkuyucu(String dosyaAdi, KokOzelDurumBilgisi ozelDurumlar) throws IOException {
        InputStream fis = new KaynakYukleyici("UTF-8").getStream(dosyaAdi);
        this.dis = new DataInputStream(new BufferedInputStream(fis));
        this.ozelDurumlar = ozelDurumlar;
    }

    @Override
    public List<Kok> hepsiniOku() throws IOException {
        Kok kok;
        ArrayList<Kok> list = new ArrayList<Kok>();
        while ((kok = this.oku()) != null) {
            list.add(kok);
        }
        this.dis.close();
        return list;
    }

    @Override
    public Kok oku() throws IOException {
        char kisaltmaSeslisi;
        String icerik;
        try {
            icerik = this.dis.readUTF();
        }
        catch (EOFException e) {
            this.dis.close();
            return null;
        }
        String asil = this.dis.readUTF();
        KelimeTipi tip = KelimeTipi.getTip(this.dis.read());
        Kok kok = tip == KelimeTipi.KISALTMA ? new Kisaltma(icerik) : new Kok(icerik, tip);
        if (asil.length() != 0) {
            kok.setAsil(asil);
        }
        if ((kisaltmaSeslisi = this.dis.readChar()) != '#') {
            ((Kisaltma)kok).setKisaltmaSonSeslisi(kisaltmaSeslisi);
        }
        int ozelDurumSayisi = this.dis.read();
        for (int i = 0; i < ozelDurumSayisi; ++i) {
            int ozelDurum = this.dis.read();
            KokOzelDurumu oz = this.ozelDurumlar.ozelDurum(ozelDurum);
            kok.ozelDurumEkle(oz);
        }
        int frekans = this.dis.readInt();
        if (frekans != 0) {
            kok.setFrekans(frekans);
        }
        return kok;
    }
}

