/*
 * Decompiled with CFR 0.152.
 */
package net.zemberek.bilgi.araclar;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.zemberek.bilgi.araclar.KokYazici;
import net.zemberek.yapi.KelimeTipi;
import net.zemberek.yapi.Kok;
import net.zemberek.yapi.kok.KokOzelDurumu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuzYaziKokYazici
implements KokYazici {
    BufferedWriter writer;
    private Map<KelimeTipi, String> tipAdlari = new HashMap<KelimeTipi, String>();

    public DuzYaziKokYazici(String dosyaAdi, Map<String, KelimeTipi> kokAdTipMap) throws IOException {
        for (Map.Entry<String, KelimeTipi> entry : kokAdTipMap.entrySet()) {
            this.tipAdlari.put(entry.getValue(), entry.getKey());
        }
        FileOutputStream fos = new FileOutputStream(dosyaAdi);
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
    }

    @Override
    public void yaz(List<Kok> kokler) throws IOException {
        this.writer.write("#-------------------------\n");
        this.writer.write("# ZEMBEREK DUZ YAZI SOZLUK \n");
        this.writer.write("#-------------------------\n");
        this.writer.write("#v0.1\n");
        for (Kok kok : kokler) {
            this.writer.write(this.getDuzMetinSozlukForm(kok));
            this.writer.newLine();
        }
        this.writer.close();
    }

    private String getDuzMetinSozlukForm(Kok kok) {
        String icerik = kok.icerik();
        if (kok.asil() != null) {
            icerik = kok.asil();
        }
        StringBuilder res = new StringBuilder(icerik).append(" ");
        if (kok.tip() == null) {
            System.out.println("tipsiz kok:" + kok);
            return res.toString();
        }
        if (!this.tipAdlari.containsKey((Object)kok.tip())) {
            System.out.println("tip icin dile ozel kisa ad bulunamadi.:" + kok.tip().name());
            return "#" + kok.icerik();
        }
        res.append(this.tipAdlari.get((Object)kok.tip())).append(" ").append(this.getOzellikString(kok.ozelDurumDizisi()));
        return res.toString();
    }

    private String getOzellikString(KokOzelDurumu[] ozelDurumlar) {
        String oz = "";
        for (KokOzelDurumu ozelDurum : ozelDurumlar) {
            if (ozelDurum.otomatikbelilenir()) continue;
            oz = oz + ozelDurum.kisaAd() + " ";
        }
        return oz;
    }
}

